/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.registry.network;

import com.bymarcin.zettaindustries.utils.WorldUtils;
import com.google.gson.Gson;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Type;
import net.minecraft.tileentity.TileEntity;

public abstract class Packet<T extends Packet<T, RES>, RES extends IMessage>
implements IMessage,
IMessageHandler<T, RES> {
    private final ByteBuf write;
    private ByteBuf read;
    private final Gson gson = new Gson();

    protected abstract void read() throws IOException;

    protected abstract void write() throws IOException;

    protected abstract RES executeOnClient();

    protected abstract RES executeOnServer();

    public Packet() {
        this.write = Unpooled.buffer();
    }

    public TileEntity readClientTileEntity() throws IOException {
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        return WorldUtils.getTileEntity(dimensionId, x, y, z);
    }

    public TileEntity readServerTileEntity() throws IOException {
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        return WorldUtils.getTileEntityServer(dimensionId, x, y, z);
    }

    public byte[] readByteArray() throws IOException {
        return this.readByteArrayData(this.read.readUnsignedShort());
    }

    public byte[] readByteArrayData(int size) throws IOException {
        byte[] data = new byte[size];
        this.read.readBytes(data, 0, size);
        return data;
    }

    public Object readJSON(Type t) throws IOException {
        return this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public <U> U readJSON(Class<U> t) throws IOException {
        return (U)this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public byte readByte() throws IOException {
        return this.read.readByte();
    }

    public short readShort() throws IOException {
        return this.read.readShort();
    }

    public byte readSignedByte() throws IOException {
        return this.read.readByte();
    }

    public short readSignedShort() throws IOException {
        return this.read.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.read.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.read.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.read.readInt();
    }

    public long readLong() throws IOException {
        return this.read.readLong();
    }

    public double readDouble() throws IOException {
        return this.read.readDouble();
    }

    public float readFloat() throws IOException {
        return this.read.readFloat();
    }

    public String readString() throws IOException {
        return ByteBufUtils.readUTF8String((ByteBuf)this.read);
    }

    public boolean readBoolean() throws IOException {
        return this.read.readBoolean();
    }

    public Packet<T, RES> writeTileLocation(TileEntity te) throws IOException, RuntimeException {
        if (te.func_145831_w() == null) {
            throw new RuntimeException("World does not exist!");
        }
        if (te.func_145837_r()) {
            throw new RuntimeException("TileEntity is invalid!");
        }
        this.write.writeInt(te.func_145831_w().field_73011_w.field_76574_g);
        this.write.writeInt(te.field_145851_c);
        this.write.writeInt(te.field_145848_d);
        this.write.writeInt(te.field_145849_e);
        return this;
    }

    public Packet<T, RES> writeByteArray(byte[] array) throws IOException, RuntimeException {
        if (array.length > 65535) {
            throw new RuntimeException("Invalid array size!");
        }
        this.write.writeShort(array.length);
        this.write.writeBytes(array);
        return this;
    }

    public Packet<T, RES> writeByteArrayData(byte[] array) throws IOException {
        this.write.writeBytes(array);
        return this;
    }

    public Packet<T, RES> writeByte(byte v) throws IOException {
        this.write.writeByte((int)v);
        return this;
    }

    public Packet<T, RES> writeBoolean(boolean v) throws IOException {
        this.write.writeBoolean(v);
        return this;
    }

    public Packet<T, RES> writeString(String s) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)this.write, (String)s);
        return this;
    }

    public Packet<T, RES> writeShort(short v) throws IOException {
        this.write.writeShort((int)v);
        return this;
    }

    public Packet<T, RES> writeInt(int v) throws IOException {
        this.write.writeInt(v);
        return this;
    }

    public Packet<T, RES> writeDouble(double v) throws IOException {
        this.write.writeDouble(v);
        return this;
    }

    public Packet<T, RES> writeFloat(float v) throws IOException {
        this.write.writeFloat(v);
        return this;
    }

    public Packet<T, RES> writeLong(long v) throws IOException {
        this.write.writeLong(v);
        return this;
    }

    public final void fromBytes(ByteBuf buf) {
        this.read = buf;
        try {
            this.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            this.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buf.writeBytes(this.write);
    }

    public final RES onMessage(T message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ((Packet)message).executeOnServer();
        }
        return ((Packet)message).executeOnClient();
    }
}

