/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import net.technicpack.mcdiscord.CommonProxy;
import net.technicpack.mcdiscord.commands.SetDiscordServer;
import net.technicpack.mcdiscord.coremod.DiscordResourcePack;
import net.technicpack.mcdiscord.data.ServerModel;
import net.technicpack.mcdiscord.discord.api.IDiscordApi;
import net.technicpack.mcdiscord.discord.api.http.DiscordFactory;
import net.technicpack.mcdiscord.discord.callback.DiscordResponseHandler;
import net.technicpack.mcdiscord.event.PlayerConnectedHandler;
import net.technicpack.mcdiscord.event.QueryDiscordHandler;
import net.technicpack.mcdiscord.network.DiscordNetwork;
import org.apache.logging.log4j.Level;

public class McDiscord
extends DummyModContainer {
    public static final String MODID = "mcdiscord";
    public static final String NAME = "MC Discord";
    public static final String VERSION = "2.0.0";
    public static CommonProxy proxy;
    @Mod.Instance
    public static McDiscord instance;
    private QueryDiscordHandler queryDiscordHandler;

    public McDiscord() {
        super(new ModMetadata());
        ModMetadata metadata = this.getMetadata();
        metadata.modId = MODID;
        metadata.version = VERSION;
        metadata.name = NAME;
        metadata.authorList = ImmutableList.of((Object)"Cannibalvox");
        metadata.url = "http://www.technicpack.net/";
        metadata.credits = "Developed by Technic";
        metadata.description = "Discord (http://discordapp.com/) integration in Minecraft.";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public Class<?> getCustomResourcePackClass() {
        return DiscordResourcePack.class;
    }

    private void initProxy(String commonType, String clientType) {
        ClassLoader mcl = Loader.instance().getModClassLoader();
        String target = FMLCommonHandler.instance().getSide().isClient() ? clientType : commonType;
        try {
            proxy = (CommonProxy)Class.forName(target, true, mcl).newInstance();
        }
        catch (Exception ex) {
            FMLLog.log((Level)Level.ERROR, (Throwable)ex, (String)"An error occured trying to load a proxy into MCDiscord", (Object[])new Object[0]);
            throw new LoaderException((Throwable)ex);
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        this.initProxy("net.technicpack.mcdiscord.CommonProxy", "net.technicpack.mcdiscord.client.ClientProxy");
        DiscordNetwork.init();
        Configuration configFile = new Configuration(event.getSuggestedConfigurationFile());
        configFile.load();
        String serverId = configFile.get("general", "Discord Server ID", "", "The discord server ID can be found in the Widgets tab of the Server Settings page.  This only has to be set on the server-side.  It may take several hours after creating a server before it's available on the API.").getString();
        configFile.save();
        ServerModel model = new ServerModel(serverId);
        proxy.setServerModel(model);
        FMLCommonHandler.instance().bus().register((Object)new PlayerConnectedHandler());
        DiscordResponseHandler responseHandler = new DiscordResponseHandler();
        FMLCommonHandler.instance().bus().register((Object)responseHandler);
        IDiscordApi api = DiscordFactory.createDiscordApi(responseHandler);
        this.queryDiscordHandler = new QueryDiscordHandler(api, model);
        FMLCommonHandler.instance().bus().register((Object)this.queryDiscordHandler);
        proxy.registerHudHandler();
    }

    @Subscribe
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SetDiscordServer(this.queryDiscordHandler));
    }
}

