/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord.event;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.technicpack.mcdiscord.data.ServerModel;
import org.lwjgl.opengl.GL11;

public class HudHandler {
    private ResourceLocation minecraftPlayers = new ResourceLocation("mcdiscord:textures/gui/mc.png");
    private ResourceLocation discordText = new ResourceLocation("mcdiscord:textures/gui/discord.png");
    private ServerModel serverModel;
    public static HudHandler INSTANCE;

    public HudHandler(ServerModel serverModel) {
        this.serverModel = serverModel;
        INSTANCE = this;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean handleMouseClick(int xPos, int yPos, int mouseClicked) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        if (HudHandler.INSTANCE.serverModel.getInviteLink() != null && !HudHandler.INSTANCE.serverModel.getInviteLink().isEmpty() && xPos >= 48 && xPos < 160 && yPos >= sr.func_78328_b() - 32 && yPos < sr.func_78328_b() - 20) {
            try {
                URI uri = new URI(HudHandler.INSTANCE.serverModel.getInviteLink());
                if (!uri.getScheme().toLowerCase().equals("http") && !uri.getScheme().toLowerCase().equals("https")) {
                    throw new URISyntaxException(HudHandler.INSTANCE.serverModel.getInviteLink(), "Unsupported protocol: " + uri.getScheme().toLowerCase());
                }
                HudHandler.visitLink(uri);
            }
            catch (URISyntaxException urisyntaxexception) {
                FMLLog.getLogger().error("Can't open url for MCDiscord", (Throwable)urisyntaxexception);
            }
        }
        return false;
    }

    private static void visitLink(URI link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, link);
        }
        catch (Throwable throwable) {
            FMLLog.getLogger().error("Couldn't open link", throwable);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void hudRenderTick(TickEvent.RenderTickEvent event) {
        int chatAlpha;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!minecraft.func_71382_s()) {
            return;
        }
        if (this.serverModel.getServerId() == null || this.serverModel.getServerId().isEmpty()) {
            return;
        }
        if (minecraft.field_71456_v == null) {
            return;
        }
        if (minecraft.field_71456_v.func_146158_b() == null) {
            return;
        }
        GuiNewChat chat = minecraft.field_71456_v.func_146158_b();
        if (minecraft.field_71474_y.field_74343_n == EntityPlayer.EnumChatVisibility.HIDDEN) {
            return;
        }
        float settingsChatAlpha = minecraft.field_71474_y.field_74357_r * 0.9f + 0.1f;
        float timeChatAlpha = 255.0f;
        if (!chat.func_146241_e()) {
            if (chat.field_146253_i.size() < 1) {
                return;
            }
            ChatLine line = (ChatLine)chat.field_146253_i.get(0);
            if (line == null) {
                return;
            }
            int timeSinceLastMsg = minecraft.field_71456_v.func_73834_c() - line.func_74540_b();
            if (timeSinceLastMsg >= 200) {
                return;
            }
            timeChatAlpha = this.getChatAlpha(timeSinceLastMsg);
        }
        if ((chatAlpha = (int)(timeChatAlpha * settingsChatAlpha)) <= 3) {
            return;
        }
        EntityLivingBase entity = minecraft.field_71451_h;
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)(sr.func_78328_b() - 32), (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GuiNewChat.func_73734_a((int)0, (int)4, (int)(MathHelper.func_76123_f((float)((float)chat.func_146228_f() / chat.func_146244_h())) + 6), (int)18, (int)(chatAlpha / 2 << 24));
        GL11.glEnable((int)3042);
        int mcPlayerCount = minecraft.field_71439_g.field_71174_a.field_147303_b.size();
        String playerCount = Integer.toString(mcPlayerCount);
        minecraft.field_71466_p.func_78261_a(playerCount, 20, 8, 0xFFFFFF + (chatAlpha << 24));
        minecraft.func_110434_K().func_110577_a(this.minecraftPlayers);
        this.renderTex(3.0f, 5.0f, 12.0f, 12.0f);
        minecraft.func_110434_K().func_110577_a(this.discordText);
        this.renderTex(48.0f, 5.0f, 12.0f, 12.0f);
        int discordTextPlayerCount = this.serverModel.getDiscordPlayerCount();
        playerCount = Integer.toString(discordTextPlayerCount);
        minecraft.field_71466_p.func_78261_a(playerCount, 65, 8, 0xFFFFFF + (chatAlpha << 24));
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderTex(float x, float y, float w, float h) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x + 0.5, (double)(y + h), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)x + 0.5 + (double)w, (double)(y + h), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)x + 0.5 + (double)w, (double)(y + 0.0f), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x + 0.5, (double)(y + 0.0f), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    private float getChatAlpha(int timeSinceLastMsg) {
        double timePercent = (double)timeSinceLastMsg / 200.0;
        timePercent = 1.0 - timePercent;
        if ((timePercent *= 10.0) < 0.0) {
            timePercent = 0.0;
        }
        if (timePercent > 1.0) {
            timePercent = 1.0;
        }
        timePercent *= timePercent;
        return (int)(255.0 * timePercent);
    }
}

