/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.technicpack.mcdiscord.McDiscord;
import net.technicpack.mcdiscord.data.ServerModel;
import net.technicpack.mcdiscord.discord.api.IDiscordApi;
import net.technicpack.mcdiscord.discord.callback.DiscordCallback;
import net.technicpack.mcdiscord.discord.io.server.Server;
import net.technicpack.mcdiscord.network.DiscordNetwork;
import net.technicpack.mcdiscord.network.packet.UpdateServerPacket;

public class QueryDiscordHandler {
    private IDiscordApi discordApi;
    private ServerModel model;
    private int ticksUntilQuery = 1;

    public QueryDiscordHandler(IDiscordApi discordApi, ServerModel model) {
        this.discordApi = discordApi;
        this.model = model;
    }

    @SubscribeEvent
    public void periodicallyQuery(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        --this.ticksUntilQuery;
        if (this.ticksUntilQuery <= 0) {
            this.ticksUntilQuery = 300;
            this.forceQuery();
        }
    }

    public void forceQuery() {
        this.discordApi.getServer(this.model.getServerId(), new DiscordCallback<Server>(true){

            @Override
            public void callback(Server result) {
                if (result != null && !McDiscord.proxy.getServerModel().equals(result)) {
                    McDiscord.proxy.getServerModel().updateServer(result);
                    DiscordNetwork.sendToAllPlayers(new UpdateServerPacket(result));
                }
            }
        });
    }
}

