/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.technicpack.mcdiscord.network.handlers.UpdateServerPacketHandler;
import net.technicpack.mcdiscord.network.packet.UpdateServerPacket;

@ChannelHandler.Sharable
public class DiscordNetwork {
    private static final DiscordNetwork INSTANCE = new DiscordNetwork();
    private SimpleNetworkWrapper networkWrapper;

    public static void init() {
        DiscordNetwork.INSTANCE.networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("mcdiscord");
        DiscordNetwork.INSTANCE.networkWrapper.registerMessage(UpdateServerPacketHandler.class, UpdateServerPacket.class, 0, Side.CLIENT);
    }

    public static void sendToAllPlayers(IMessage packet) {
        DiscordNetwork.INSTANCE.networkWrapper.sendToAll(packet);
    }

    public static void sendToNearbyPlayers(IMessage message, int dimension, float x, float y, float z, float radius) {
        DiscordNetwork.INSTANCE.networkWrapper.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, (double)x, (double)y, (double)z, (double)radius));
    }

    public static void sendToPlayer(IMessage message, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            DiscordNetwork.INSTANCE.networkWrapper.sendTo(message, (EntityPlayerMP)player);
        }
    }
}

