/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntigration.core.triggers;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItem;
import ic2.core.Ic2Icons;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityAdvancedMachine;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.item.ItemBatteryDischarged;
import ic2.core.util.StackUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerCapacitor
implements ITriggerExternal {
    int action;

    public TriggerCapacitor(int action) {
        this.action = action;
    }

    public IStatementParameter createParameter(int arg0) {
        return null;
    }

    public String getDescription() {
        switch (this.action) {
            case 0: {
                return "Capacitor Empty";
            }
            case 1: {
                return "Capacitor Has Energy";
            }
            case 2: {
                return "Space For Energy";
            }
            case 3: {
                return "Capacitor Full";
            }
            case 4: {
                return "Charging Empty Item";
            }
            case 5: {
                return "Charging Partially Charged Item";
            }
            case 6: {
                return "Charging Fully Charged Item";
            }
            case 7: {
                return "Discharging Empty Item";
            }
            case 8: {
                return "Discharging Partially Charged Item";
            }
            case 9: {
                return "Discharging Fully Charged Item";
            }
        }
        return "This shouldn't happen";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Ic2Icons.getTexture("triggers")[this.getIconID()];
    }

    private int getIconID() {
        switch (this.action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 18;
            }
            case 7: {
                return 21;
            }
            case 8: {
                return 19;
            }
            case 9: {
                return 20;
            }
        }
        return 0;
    }

    public String getUniqueTag() {
        return "trigger.EUCapacitor." + this.action;
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister arg0) {
    }

    public IStatement rotateLeft() {
        return this;
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection dir, IStatementContainer arg2, IStatementParameter[] arg3) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityElectricMachine) {
            TileEntityElectricMachine machine = (TileEntityElectricMachine)tile;
            boolean hasEnergy = machine.energy > machine.maxInput;
            boolean hasRoom = machine.energy < machine.maxEnergy - machine.maxInput;
            boolean dischargeEnergy = false;
            boolean dischargeRoom = false;
            if (machine.inventory[1] != null && machine.inventory[1].func_77973_b() instanceof IElectricItem) {
                IElectricItem ei = (IElectricItem)machine.inventory[1].func_77973_b();
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(machine.inventory[1]);
                if (nbt.func_74762_e("charge") > 0) {
                    dischargeEnergy = true;
                }
                if ((double)nbt.func_74762_e("charge") < ei.getMaxCharge(machine.inventory[1])) {
                    dischargeRoom = true;
                }
            } else if (machine.inventory[1] != null && machine.inventory[1].func_77973_b() instanceof ItemBatteryDischarged) {
                dischargeEnergy = false;
                dischargeRoom = true;
            } else if (this.action == 7 || this.action == 8 || this.action == 9) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        } else if (tile instanceof TileEntityAdvancedMachine) {
            TileEntityAdvancedMachine machine = (TileEntityAdvancedMachine)tile;
            boolean hasEnergy = machine.energy > machine.maxInput;
            boolean hasRoom = machine.energy < machine.maxEnergy - machine.maxInput;
            boolean dischargeEnergy = false;
            boolean dischargeRoom = false;
            if (machine.inventory[0] != null && machine.inventory[0].func_77973_b() instanceof IElectricItem) {
                IElectricItem ei = (IElectricItem)machine.inventory[0].func_77973_b();
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(machine.inventory[0]);
                if (nbt.func_74762_e("charge") > 0) {
                    dischargeEnergy = true;
                }
                if ((double)nbt.func_74762_e("charge") < ei.getMaxCharge(machine.inventory[0])) {
                    dischargeRoom = true;
                }
            } else if (machine.inventory[0] != null && machine.inventory[0].func_77973_b() instanceof ItemBatteryDischarged) {
                dischargeEnergy = false;
                dischargeRoom = true;
            } else if (this.action == 7 || this.action == 8 || this.action == 9) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        } else if (tile instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator gen = (TileEntityBaseGenerator)tile;
            boolean hasEnergy = gen.storage > 0;
            boolean hasRoom = gen.storage < gen.maxStorage;
            boolean chargeEnergy = false;
            boolean chargeRoom = false;
            if (gen.inventory[0] != null && gen.inventory[0].func_77973_b() instanceof IElectricItem) {
                IElectricItem ei = (IElectricItem)gen.inventory[0].func_77973_b();
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(gen.inventory[0]);
                if (nbt.func_74762_e("charge") > 0) {
                    chargeEnergy = true;
                }
                if ((double)nbt.func_74762_e("charge") < ei.getMaxCharge(gen.inventory[0])) {
                    chargeRoom = true;
                }
            } else if (gen.inventory[0] != null && gen.inventory[0].func_77973_b() instanceof ItemBatteryDischarged) {
                chargeEnergy = false;
                chargeRoom = true;
            } else if (this.action == 4 || this.action == 5 || this.action == 6) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
            }
        } else if (tile instanceof TileEntityElectricBlock) {
            NBTTagCompound nbt;
            IElectricItem ei;
            TileEntityElectricBlock block = (TileEntityElectricBlock)tile;
            boolean hasEnergy = block.energy > block.output;
            boolean hasRoom = block.energy < block.maxStorage;
            boolean chargeEnergy = false;
            boolean chargeRoom = false;
            boolean dischargeEnergy = false;
            boolean dischargeRoom = false;
            if (block.inventory[0] != null && block.inventory[0].func_77973_b() instanceof IElectricItem) {
                ei = (IElectricItem)block.inventory[0].func_77973_b();
                nbt = StackUtil.getOrCreateNbtData(block.inventory[0]);
                if (nbt.func_74762_e("charge") > 0) {
                    chargeEnergy = true;
                }
                if ((double)nbt.func_74762_e("charge") < ei.getMaxCharge(block.inventory[0])) {
                    chargeRoom = true;
                }
            } else if (block.inventory[0] != null && block.inventory[0].func_77973_b() instanceof ItemBatteryDischarged) {
                chargeEnergy = false;
                chargeRoom = true;
            } else if (this.action == 4 || this.action == 5 || this.action == 6) {
                return false;
            }
            if (block.inventory[1] != null && block.inventory[1].func_77973_b() instanceof IElectricItem) {
                ei = (IElectricItem)block.inventory[1].func_77973_b();
                nbt = StackUtil.getOrCreateNbtData(block.inventory[1]);
                if (nbt.func_74762_e("charge") > 0) {
                    dischargeEnergy = true;
                }
                if ((double)nbt.func_74762_e("charge") < ei.getMaxCharge(block.inventory[0])) {
                    dischargeRoom = true;
                }
            } else if (block.inventory[1] != null && block.inventory[1].func_77973_b() instanceof ItemBatteryDischarged) {
                dischargeEnergy = false;
                dischargeRoom = true;
            } else if (this.action == 7 || this.action == 8 || this.action == 9) {
                return false;
            }
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        }
        return false;
    }
}

