/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.recipe.ICraftingRecipeManagerList;
import ic2.core.AdvShapelessRecipe;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class AdvRecipe
implements IRecipe,
ICraftingRecipeManagerList.IAdvRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    public ItemStack output;
    public Object[] input;
    public int height;
    public int length;
    public boolean hidden;
    public List<ICraftingRecipeManagerList.RecipeObject> objects = new ArrayList<ICraftingRecipeManagerList.RecipeObject>();

    public static AdvRecipe addAndRegister(ItemStack result, Object[] args) {
        AdvRecipe recipe = new AdvRecipe(result, args);
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
        return recipe;
    }

    public AdvRecipe(ItemStack par1, Object[] par2) {
        this.output = par1.func_77946_l();
        ArrayList<String> template = new ArrayList<String>();
        Character lastChar = null;
        HashMap items = new HashMap();
        for (Object obj : par2) {
            if (obj == null) continue;
            if (obj instanceof String) {
                if (lastChar == null) {
                    template.add((String)obj);
                    continue;
                }
                String text = (String)obj;
                if (text.startsWith("liquid$")) {
                    items.put(lastChar, AdvRecipe.getFluids(text));
                } else {
                    items.put(lastChar, OreDictionary.getOres((String)text));
                }
                lastChar = null;
                continue;
            }
            if (obj instanceof Character) {
                lastChar = (Character)obj;
                continue;
            }
            if (obj instanceof Boolean) {
                this.hidden = (Boolean)obj;
                continue;
            }
            if (obj instanceof Item) {
                items.put(lastChar, new ItemStack((Item)obj, 1, Short.MAX_VALUE));
                lastChar = null;
                continue;
            }
            if (obj instanceof Block) {
                items.put(lastChar, new ItemStack((Block)obj, 1, Short.MAX_VALUE));
                lastChar = null;
                continue;
            }
            if (!(obj instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)obj;
            if ((stack = ItemStack.func_77944_b((ItemStack)stack)).func_77973_b() instanceof IElectricItem && !(stack.func_77973_b() instanceof ISpecialElectricItem)) {
                stack.func_77964_b(Short.MAX_VALUE);
                items.put(lastChar, stack);
                lastChar = null;
                continue;
            }
            items.put(lastChar, stack);
            lastChar = null;
        }
        if (template.size() == 0 || template.size() > 3) {
            throw new RuntimeException("Template is not Matching");
        }
        String shape = "";
        for (String key : template) {
            shape = shape + key;
            this.length = key.length();
            ++this.height;
        }
        if (this.length * this.height != shape.length()) {
            throw new RuntimeException("Template is not Matching");
        }
        this.input = new Object[this.length * this.height];
        int x = 0;
        for (char chars : shape.toCharArray()) {
            Object obj = items.get(Character.valueOf(chars));
            this.input[x] = obj;
            this.addObject(x, obj);
            ++x;
        }
    }

    private void addObject(int slot, Object item) {
        if (item instanceof ItemStack) {
            this.objects.add(new ICraftingRecipeManagerList.RecipeObject(slot, (ItemStack)item));
        } else if (item instanceof ArrayList) {
            this.objects.add(new ICraftingRecipeManagerList.RecipeObject(slot, (ArrayList)item));
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.length; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.length && subY < this.height) {
                    target = this.input[subX + subY * this.length];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (AdvRecipe.ItemsMatch((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (ItemStack item : (ArrayList)target) {
                        matched = matched || AdvRecipe.ItemsMatch(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting par1) {
        int totalCharge = 0;
        for (int i = 0; i < par1.func_70302_i_(); ++i) {
            ItemStack stack = par1.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IElectricItem)) continue;
            totalCharge = (int)((double)totalCharge + ElectricItem.manager.getCharge(stack));
        }
        ItemStack out = this.output.func_77946_l();
        if (out.func_77973_b() instanceof IElectricItem && totalCharge > 0) {
            ElectricItem.manager.charge(out, totalCharge, Integer.MAX_VALUE, true, false);
        }
        return out;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public static boolean canShow(Object[] input, ItemStack output, boolean hidden) {
        return !(IC2.enableSecretRecipeHiding && hidden || AdvRecipe.recipeContains(input, Ic2Items.chargedReBattery) || AdvRecipe.recipeContains(input, Ic2Items.industrialDiamond) && output.func_77973_b() == Items.field_151045_i);
    }

    public static boolean recipeContains(Object[] inputs, ItemStack item) {
        for (Object input : inputs) {
            if (input == null || !(input instanceof ItemStack ? AdvRecipe.ItemsMatch((ItemStack)input, item) : input instanceof ArrayList && AdvRecipe.ItemsMatch(item, (ArrayList)input))) continue;
            return true;
        }
        return false;
    }

    public static boolean canShow(AdvRecipe recipe) {
        return AdvRecipe.canShow(recipe.input, recipe.output, recipe.hidden);
    }

    public static boolean canShow(AdvShapelessRecipe recipe) {
        return AdvRecipe.canShow(recipe.input.toArray(), recipe.output, recipe.hidden);
    }

    public static boolean ItemsMatch(ItemStack par1, ItemStack par2) {
        return par1 != null && par2 != null && par1.func_77973_b() == par2.func_77973_b() && (par1.func_77960_j() == par2.func_77960_j() || par1.func_77960_j() == Short.MAX_VALUE || par2.func_77960_j() == Short.MAX_VALUE);
    }

    public static boolean ItemsMatch(ItemStack par1, ArrayList<ItemStack> par2) {
        for (ItemStack stack : par2) {
            if (!AdvRecipe.ItemsMatch(stack, par1)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> getFluids(String text) {
        int meta;
        int id;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int colon = text.indexOf(58);
        if (colon != -1) {
            id = Integer.valueOf(text.substring(7, colon - 1));
            meta = Integer.valueOf(text.substring(colon + 1));
        } else {
            id = Integer.valueOf(text.substring(7));
            meta = -1;
        }
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            FluidStack stack = data.fluid;
            if (stack == null || stack.getFluid() == null || !stack.getFluid().canBePlacedInWorld() || id != Block.func_149682_b((Block)stack.getFluid().getBlock())) continue;
            list.add(data.filledContainer);
        }
        return list;
    }

    @Override
    public boolean isShaped() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public List<ICraftingRecipeManagerList.RecipeObject> getRecipeInput() {
        return new ArrayList<ICraftingRecipeManagerList.RecipeObject>(this.objects);
    }

    @Override
    public int getRecipeHeight() {
        return this.height;
    }

    @Override
    public int getRecipeLength() {
        return this.length;
    }
}

