/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockTex;
import ic2.core.util.IExtraData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class BlockPoleFence
extends BlockTex
implements IExtraData {
    public static Set<Item> validBoots = new HashSet<Item>();

    public BlockPoleFence(int sprite) {
        super(sprite, Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        this.func_149663_c("blockFenceIron");
        this.func_149647_a(IC2.tabIC2);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("fence");
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        if (this.field_149764_J == Material.field_151573_f && this.isPole(world, i, j, k)) {
            return AxisAlignedBB.func_72330_a((double)((float)i + 0.375f), (double)j, (double)((float)k + 0.375f), (double)((float)i + 0.625f), (double)((float)j + 1.0f), (double)((float)k + 0.625f));
        }
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 1.5f), (double)(k + 1));
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        if (this.field_149764_J == Material.field_151573_f && this.isPole(world, i, j, k)) {
            return AxisAlignedBB.func_72330_a((double)((float)i + 0.375f), (double)j, (double)((float)k + 0.375f), (double)((float)i + 0.625f), (double)((float)j + 1.0f), (double)((float)k + 0.625f));
        }
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public boolean isPole(World world, int i, int j, int k) {
        return world.func_147439_a(i - 1, j, k) != this && world.func_147439_a(i + 1, j, k) != this && world.func_147439_a(i, j, k - 1) != this && world.func_147439_a(i, j, k + 1) != this;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        Item id;
        if (this.field_149764_J != Material.field_151573_f || !this.isPole(world, i, j, k) || !(entity instanceof EntityPlayer)) {
            return;
        }
        boolean powered = world.func_72805_g(i, j, k) > 0;
        boolean metalShoes = false;
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack shoes = player.field_71071_by.field_70460_b[0];
        if (shoes != null && (validBoots.contains(id = shoes.func_77973_b()) || shoes.func_77973_b() instanceof IMetalArmor && ((IMetalArmor)shoes.func_77973_b()).isMetalArmor(shoes, player))) {
            metalShoes = true;
        }
        if (!powered || !metalShoes) {
            if (player.func_70093_af()) {
                if (player.field_70181_x < -0.25) {
                    EntityPlayer entityPlayer = player;
                    entityPlayer.field_70181_x *= (double)0.9f;
                } else {
                    player.field_70143_R = 0.0f;
                }
            }
        } else {
            world.func_72921_c(i, j, k, world.func_72805_g(i, j, k) - 1, 0);
            EntityPlayer entityPlayer2 = player;
            entityPlayer2.field_70181_x += (double)0.075f;
            if (player.field_70181_x > 0.0) {
                EntityPlayer entityPlayer3 = player;
                entityPlayer3.field_70181_x *= 1.029999971389771;
                player.field_70143_R = 0.0f;
            }
            if (player.func_70093_af()) {
                if (player.field_70181_x > 0.300000011920929) {
                    player.field_70181_x = 0.300000011920929;
                }
            } else if (player.field_70181_x > 1.5) {
                player.field_70181_x = 1.5;
            }
        }
    }

    @Override
    public void init() {
        Ic2Items.ironFence = new ItemStack((Block)this);
        validBoots.add((Item)Items.field_151151_aj);
        validBoots.add((Item)Items.field_151167_ab);
        validBoots.add((Item)Items.field_151029_X);
    }

    public static void loadBoots(Configuration config) {
        Property prop = config.get("general", "Magnetizer Boots Registry", BlockPoleFence.getBootsRegistryString());
        prop.comment = "Allows to add Boots to the magnitzer registry";
        validBoots.clear();
        BlockPoleFence.setBootsRegistryString(prop.getString());
    }

    private static String getBootsRegistryString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (Item entry : validBoots) {
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(Item.field_150901_e.func_148750_c((Object)entry));
        }
        return ret.toString();
    }

    private static void setBootsRegistryString(String str) {
        String[] items;
        for (String part : items = str.trim().split("\\s*,\\s*")) {
            String[] split = part.split(":");
            Item itemID = GameRegistry.findItem((String)split[0], (String)split[1]);
            if (itemID == null) {
                FMLLog.getLogger().info("Boots Registry Error: Could not find: " + part + " Please check the registry names to fix it");
                continue;
            }
            validBoots.add(itemID);
        }
    }
}

