/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockTex;
import ic2.core.util.IExtraData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockScaffold
extends BlockTex
implements IExtraData {
    public static int standardStrength = 2;
    public static int standardIronStrength = 5;
    public static int reinforcedStrength = 5;
    public static int reinforcedIronStrength = 12;
    public static int tickDelay = 1;
    public Material material;
    public int blockIndexInTexture;

    public BlockScaffold(Material material) {
        super(material);
        this.blockIndexInTexture = material == Material.field_151573_f ? 132 : 116;
        this.func_149647_a(IC2.tabIC2);
        this.material = material;
        if (material == Material.field_151575_d) {
            this.func_149711_c(0.5f);
            this.func_149752_b(0.2f);
            this.func_149663_c("blockScaffold");
            this.func_149672_a(field_149766_f);
        } else if (material == Material.field_151573_f) {
            this.func_149711_c(0.8f);
            this.func_149752_b(10.0f);
            this.func_149663_c("blockIronScaffold");
            this.func_149672_a(field_149777_j);
        }
    }

    @Override
    public void init() {
        if (this.func_149688_o() == Material.field_151575_d) {
            Ic2Items.scaffold = new ItemStack((Block)this);
        } else if (this.func_149688_o() == Material.field_151573_f) {
            Ic2Items.ironScaffold = new ItemStack((Block)this);
        }
    }

    public int getStandardStrength() {
        if (this.material == Material.field_151573_f) {
            return standardIronStrength;
        }
        return standardStrength;
    }

    public int getReinforcedStrength() {
        if (this.material == Material.field_151573_f) {
            return reinforcedIronStrength;
        }
        return reinforcedStrength;
    }

    public IIcon func_149673_e(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        int meta = iblockaccess.func_72805_g(i, j, k);
        if (side < 2) {
            return Ic2Icons.getTexture("b0")[this.blockIndexInTexture + 1];
        }
        if (meta == this.getReinforcedStrength()) {
            return Ic2Icons.getTexture("b0")[this.blockIndexInTexture + 2];
        }
        return Ic2Icons.getTexture("b0")[this.blockIndexInTexture];
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side < 2) {
            return Ic2Icons.getTexture("b0")[this.blockIndexInTexture + 1];
        }
        return Ic2Icons.getTexture("b0")[this.blockIndexInTexture];
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.field_70143_R = 0.0f;
            if (player.field_70181_x < -0.15) {
                player.field_70181_x = -0.15;
            }
            if (player.func_70093_af()) {
                player.field_70181_x = 0.08;
            }
            if (IC2.keyboard.isForwardKeyDown(player) && player.field_70181_x < 0.2) {
                player.field_70181_x = this.material == Material.field_151573_f ? 0.3 : 0.2;
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        float factor = 1.0f;
        float f = factor / 16.0f;
        return AxisAlignedBB.func_72330_a((double)((float)i + f), (double)j, (double)((float)k + f), (double)((float)i + factor - f), (double)((float)j + factor), (double)((float)k + factor - f));
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        ArrayList<ItemStack> tr = new ArrayList<ItemStack>();
        tr.add(new ItemStack((Block)this, 1));
        if (meta == this.getReinforcedStrength()) {
            if (this.material == Material.field_151573_f) {
                tr.add(new ItemStack(Ic2Items.ironFence.func_77973_b(), 1));
            }
            if (this.material == Material.field_151575_d) {
                tr.add(new ItemStack(Items.field_151055_y, 2));
            }
        }
        return tr;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        ItemStack sticks = entityplayer.field_71071_by.func_70448_g();
        if (sticks == null || this.material == Material.field_151575_d && (sticks.func_77973_b() != Items.field_151055_y || sticks.field_77994_a < 2) || this.material == Material.field_151573_f && sticks.func_77973_b() != Ic2Items.ironFence.func_77973_b()) {
            return false;
        }
        if (world.func_72805_g(i, j, k) == this.getReinforcedStrength() || !this.isPillar(world, i, j, k)) {
            return false;
        }
        if (this.material == Material.field_151575_d) {
            ItemStack itemStack = sticks;
            itemStack.field_77994_a -= 2;
        } else {
            ItemStack itemStack2 = sticks;
            --itemStack2.field_77994_a;
        }
        if (entityplayer.func_71045_bC().field_77994_a <= 0) {
            entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
        }
        world.func_72921_c(i, j, k, this.getReinforcedStrength(), 3);
        world.func_147458_c(i, j, k, i, j, k);
        IC2.network.get().announceBlockUpdate(world, i, j, k);
        return true;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) == this) {
            while (world.func_147439_a(i, j, k) == this) {
                ++j;
            }
            if (this.func_149742_c(world, i, j, k) && j < IC2.getWorldHeight(world)) {
                world.func_147449_b(i, j, k, (Block)this);
                this.func_149714_e(world, i, j, k, 0);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    ItemStack currentEquippedItem = entityplayer.func_71045_bC();
                    --currentEquippedItem.field_77994_a;
                    if (entityplayer.func_71045_bC().field_77994_a <= 0) {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
                    }
                }
            }
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return this.getStrengthFrom(world, i, j, k) > -1 && super.func_149742_c(world, i, j, k);
    }

    public boolean isPillar(World world, int i, int j, int k) {
        while (world.func_147439_a(i, j, k) == this) {
            --j;
        }
        return world.func_147445_c(i, j, k, false);
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        this.updateSupportStatus(world, i, j, k);
    }

    public void func_149714_e(World world, int i, int j, int k, int l) {
        this.func_149674_a(world, i, j, k, null);
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        int ownStrength = world.func_72805_g(i, j, k);
        if (ownStrength >= this.getReinforcedStrength()) {
            if (!this.isPillar(world, i, j, k)) {
                ownStrength = this.getStrengthFrom(world, i, j, k);
                ItemStack drop = new ItemStack(Items.field_151055_y, 2);
                if (this.material == Material.field_151573_f) {
                    drop = new ItemStack(Ic2Items.ironFence.func_77973_b());
                }
                this.func_149642_a(world, i, j, k, drop);
            }
        } else {
            ownStrength = this.getStrengthFrom(world, i, j, k);
        }
        if (ownStrength <= -1) {
            world.func_147468_f(i, j, k);
            this.func_149642_a(world, i, j, k, new ItemStack((Block)this));
        } else if (ownStrength != world.func_72805_g(i, j, k)) {
            world.func_72921_c(i, j, k, ownStrength, 3);
            world.func_147458_c(i, j, k, i, j, k);
        }
    }

    public int getStrengthFrom(World world, int i, int j, int k) {
        int strength = 0;
        if (this.isPillar(world, i, j - 1, k)) {
            strength = this.getStandardStrength() + 1;
        }
        strength = this.compareStrengthTo(world, i, j - 1, k, strength);
        strength = this.compareStrengthTo(world, i + 1, j, k, strength);
        strength = this.compareStrengthTo(world, i - 1, j, k, strength);
        strength = this.compareStrengthTo(world, i, j, k + 1, strength);
        strength = this.compareStrengthTo(world, i, j, k - 1, strength);
        return strength - 1;
    }

    public int compareStrengthTo(World world, int i, int j, int k, int strength) {
        int s = 0;
        if (world.func_147439_a(i, j, k) == this && (s = world.func_72805_g(i, j, k)) > this.getReinforcedStrength()) {
            s = this.getReinforcedStrength();
        }
        if (s > strength) {
            return s;
        }
        return strength;
    }

    public void updateSupportStatus(World world, int i, int j, int k) {
        world.func_147464_a(i, j, k, (Block)this, tickDelay);
    }
}

