/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropCoffee
extends CropCardBase {
    @Override
    public String name() {
        return "Coffee";
    }

    @Override
    public String discoveredBy() {
        return "Snoochy";
    }

    @Override
    public int tier() {
        return 7;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Leaves", "Ingrident", "Beans"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        if (crop.getSize() == 5) {
            return Ic2Icons.getTexture("bc")[43];
        }
        if (crop.getSize() == 4) {
            return Ic2Icons.getTexture("bc")[42];
        }
        return Ic2Icons.getTexture("bc")[31 + crop.getSize()];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 5 && crop.getLightLevel() >= 9;
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)(0.4 * (double)humidity + 1.4 * (double)nutrients + 1.2 * (double)air);
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (crop.getSize() == 3) {
            return (int)((double)super.growthDuration(crop) * 0.5);
        }
        if (crop.getSize() == 4) {
            return (int)((double)super.growthDuration(crop) * 1.5);
        }
        return super.growthDuration(crop);
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getSize() == 4) {
            return null;
        }
        return new ItemStack(Ic2Items.coffeeBeans.func_77973_b());
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 3;
    }

    @Override
    public int maxSize() {
        return 5;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

