/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockContainerCommon;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.generator.tileentity.TileEntityReactorChamberSteam;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockReactorChamber
extends BlockContainerCommon {
    public static Class tileEntityReactorChamberClass = TileEntityReactorChamberElectric.class;

    public BlockReactorChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
        this.func_149663_c("blockReactorChamber");
        this.func_149647_a(IC2.tabIC2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int par2) {
        if (side == 0) {
            return Ic2Icons.getTexture("b0")[par2 == 0 ? 16 : 18];
        }
        if (side == 1) {
            return Ic2Icons.getTexture("b0")[par2 == 0 ? 17 : 19];
        }
        return Ic2Icons.getTexture("b0")[par2 == 0 ? 67 : 68];
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        if (!this.isReactorNearby(world, i, j, k, world.func_72805_g(i, j, k) == 1)) {
            this.func_149642_a(world, i, j, k, new ItemStack(world.func_147439_a(i, j, k), 1, world.func_72805_g(i, j, k)));
            world.func_147468_f(i, j, k);
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return true;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        int n;
        int meta = world.func_72805_g(i, j, k);
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k, meta == 1);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
            return;
        }
        int puffs = reactor.heat / 1000;
        if (puffs <= 0) {
            return;
        }
        puffs = world.field_73012_v.nextInt(puffs);
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
        puffs -= world.field_73012_v.nextInt(4) + 3;
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public boolean isReactorNearby(World world, int i, int j, int k, boolean steam) {
        int count = 0;
        if (this.isReactorAt(world, i + 1, j, k, steam)) {
            ++count;
        }
        if (this.isReactorAt(world, i - 1, j, k, steam)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j + 1, k, steam)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j - 1, k, steam)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k + 1, steam)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k - 1, steam)) {
            ++count;
        }
        return count == 1;
    }

    public boolean isReactorAt(World world, int x, int y, int z, boolean steam) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityNuclearReactor) {
            if (steam) {
                return Item.func_150898_a((Block)world.func_147439_a(x, y, z)) == Ic2Items.steamReactor.func_77973_b() && world.func_72805_g(x, y, z) == Ic2Items.steamReactor.func_77960_j();
            }
            return Item.func_150898_a((Block)world.func_147439_a(x, y, z)) == Ic2Items.nuclearReactor.func_77973_b() && world.func_72805_g(x, y, z) == Ic2Items.nuclearReactor.func_77960_j();
        }
        return false;
    }

    public TileEntityNuclearReactor getReactorEntity(World world, int i, int j, int k, boolean steam) {
        if (this.isReactorAt(world, i + 1, j, k, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i + 1, j, k);
        }
        if (this.isReactorAt(world, i - 1, j, k, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i - 1, j, k);
        }
        if (this.isReactorAt(world, i, j + 1, k, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j + 1, k);
        }
        if (this.isReactorAt(world, i, j - 1, k, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j - 1, k);
        }
        if (this.isReactorAt(world, i, j, k + 1, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j, k + 1);
        }
        if (this.isReactorAt(world, i, j, k - 1, steam)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j, k - 1);
        }
        this.func_149695_a(world, i, j, k, world.func_147439_a(i, j, k));
        return null;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        int meta = world.func_72805_g(i, j, k);
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k, meta == 1);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
            return false;
        }
        return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityplayer, reactor);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Ic2Items.machine.func_77973_b();
    }

    public int func_149692_a(int meta) {
        return Ic2Items.machine.func_77960_j();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public TileEntity func_149915_a(World p_149915_1_, int par2) {
        try {
            switch (par2) {
                case 0: {
                    return (TileEntity)tileEntityReactorChamberClass.newInstance();
                }
                case 1: {
                    return new TileEntityReactorChamberSteam();
                }
            }
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init() {
        Ic2Items.reactorChamber = new ItemStack((Block)this, 1, 0);
        Ic2Items.steamReactorChamber = new ItemStack((Block)this, 1, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        for (int i = 0; i < 16; ++i) {
            ItemStack is = new ItemStack((Block)this, 1, i);
            if (p_149666_1_.func_77667_c(is) == null) continue;
            p_149666_3_.add(is);
        }
    }
}

