/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.Direction;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.ContainerIC2;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.generator.container.ContainerNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityReactorChamber;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class TileEntityNuclearReactor
extends TileEntityMachine
implements IHasGui,
IReactor {
    public static Random randomizer = new Random();
    private static Direction[] directions = Direction.values();
    public int output = 0;
    public int updateTicker = randomizer.nextInt(this.getTickRate());
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    public boolean redstonePowered = false;
    public AudioSource audioSourceMain = null;
    public AudioSource audioSourceGeiger = null;
    private int lastOutput = 0;
    private static int[][] slots = new int[10][];

    public TileEntityNuclearReactor() {
        super(54);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        super.onUnloaded();
    }

    @Override
    public String func_145825_b() {
        return "Nuclear Reactor";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.output = nbttagcompound.func_74762_e("output");
        }
        catch (Exception e) {
            this.output = nbttagcompound.func_74765_d("output");
        }
        this.heat = nbttagcompound.func_74762_e("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("heat", this.heat);
        nbttagcompound.func_74768_a("output", this.output);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (!this.field_145850_b.func_72873_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2)) {
            this.output = 0;
        } else {
            this.dropAllUnfittingStuff();
            this.output = 0;
            this.maxHeat = 10000;
            this.hem = 1.0f;
            this.processChambers();
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.heat >= 1000 || this.output > 0);
            this.func_70296_d();
        }
        IC2.network.get().updateTileEntityField(this, "output");
    }

    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.field_77994_a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactor.isUsefulItem(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public static boolean isUsefulItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() instanceof IReactorComponent) {
            return true;
        }
        Item id = item.func_77973_b();
        return id == Ic2Items.reEnrichedUraniumCell.func_77973_b() || id == Ic2Items.nearDepletedUraniumCell.func_77973_b();
    }

    public void eject(ItemStack drop) {
        if (!IC2.platform.isSimulating() || drop == null) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(this.field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d, (double)this.field_145848_d + d2, (double)this.field_145849_e + d3, drop);
        entityitem.field_145804_b = 10;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public boolean calculateHeatEffects() {
        Material mat;
        Block id;
        int[] coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.field_145850_b.field_73012_v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
            id = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2]);
            if (id == null) {
                this.field_145850_b.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
            } else if (id.func_149712_f(this.field_145850_b, coord[0], coord[1], coord[2]) <= -1.0f) {
                mat = id.func_149688_o();
                if (mat == Material.field_151576_e || mat == Material.field_151573_f || mat == Material.field_151587_i || mat == Material.field_151578_c || mat == Material.field_151571_B) {
                    this.field_145850_b.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150356_k, 15, 3);
                } else {
                    this.field_145850_b.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                EntityLivingBase ent = (EntityLivingBase)list1.get(l);
                ent.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)this.field_145850_b.field_73012_v.nextInt(4) * this.hem)));
            }
        }
        if (power >= 0.5f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2])) != null && id.func_149688_o() == Material.field_151586_h) {
            this.field_145850_b.func_147468_f(coord[0], coord[1], coord[2]);
        }
        if (power >= 0.4f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.field_145850_b.func_147439_a(coord[0], coord[1], coord[2])) != null && ((mat = id.func_149688_o()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
            this.field_145850_b.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius};
        if (c[0] == this.field_145851_c && c[1] == this.field_145848_d && c[2] == this.field_145849_e) {
            return null;
        }
        return c;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack thing = this.getMatrixCoord(x, y);
                    if (thing == null || !(thing.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)thing.func_77973_b();
                    comp.processChamber(this, thing, x, y, pass == 0);
                }
            }
        }
    }

    @Override
    public boolean produceEnergy() {
        return (this.redstonePowered || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) && IC2.energyGeneratorNuclear != 0;
    }

    public ItemStack getMatrixCoord(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return null;
        }
        return this.func_70301_a(x + y * 9);
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return super.func_70301_a(i);
    }

    public void setMatrixCoord(int x, int y, ItemStack stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        this.func_70299_a(x + y * 9, stack);
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            this.setMatrixCoord(size - 1, i / 9, itemstack);
        } else {
            super.func_70299_a(i, itemstack);
        }
    }

    public short getReactorSize() {
        if (this.field_145850_b == null) {
            return 9;
        }
        short rows = 3;
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            rows = (short)(rows + 1);
        }
        return rows;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerNuclearReactor(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiNuclearReactor";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0) {
                if (this.audioSourceMain != null && this.audioSourceMain.isRemoved()) {
                    this.audioSourceMain = null;
                }
                if (this.audioSourceGeiger != null && this.audioSourceGeiger.isRemoved()) {
                    this.audioSourceGeiger = null;
                }
                if (this.lastOutput <= 0) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40) {
                    if (this.lastOutput <= 0 || this.lastOutput >= 40) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, IC2.audioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80) {
                    if (this.lastOutput < 40 || this.lastOutput >= 80) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, IC2.audioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80 && this.lastOutput < 80) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, IC2.audioManager.defaultVolume);
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ChunkCoordinates getPosition() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        return this.heat += amount;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrixCoord(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrixCoord(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                ItemStack stack = this.getMatrixCoord(x, y);
                if (stack != null && stack.func_77973_b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(this, stack);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setMatrixCoord(x, y, null);
            }
        }
        IC2.log.log(Level.INFO, "Nuclear Reactor at " + this.field_145850_b.field_73011_w.field_76574_g + ":(" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") melted (explosion power " + (boomPower *= this.hem * boomMod) + ")");
        if (boomPower > IC2.explosionPowerReactorMax) {
            boomPower = IC2.explosionPowerReactorMax;
        }
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            this.field_145850_b.func_147468_f(target.field_145851_c, target.field_145848_d, target.field_145849_e);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, this.field_145851_c, this.field_145848_d, this.field_145849_e, boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        return this.output += (short)energy;
    }

    public int[] func_94128_d(int var1) {
        int size = this.getReactorSize();
        if (slots[size] == null) {
            TileEntityNuclearReactor.slots[size] = new int[6 * size];
            int k = 0;
            for (int y = 0; y < 6; ++y) {
                int x = 0;
                while (x < size) {
                    TileEntityNuclearReactor.slots[size][k] = x + y * 9;
                    ++x;
                    ++k;
                }
            }
        }
        return slots[size];
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.output;
    }

    @Override
    public void setRedstoneSignal(boolean redstone) {
        this.redstonePowered = redstone;
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }
}

