/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.Ic2Items;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityNuclearReactorSteam
extends TileEntityNuclearReactor
implements ISteamReactor,
IFluidHandler {
    private FluidTank water = new FluidTank(2000);
    private FluidTank steam = new FluidTank(20000);

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public boolean produceEnergy() {
        return this.redstonePowered || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.field_77994_a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactorSteam.hasUse(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public static boolean hasUse(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ISteamReactorComponent) {
            return true;
        }
        Item id = item.func_77973_b();
        return id == Ic2Items.reEnrichedUraniumCell.func_77973_b() || id == Ic2Items.nearDepletedUraniumCell.func_77973_b();
    }

    @Override
    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack thing = this.getMatrixCoord(x, y);
                    if (thing == null || !(thing.func_77973_b() instanceof ISteamReactorComponent)) continue;
                    ISteamReactorComponent comp = (ISteamReactorComponent)thing.func_77973_b();
                    comp.processTick(this, thing, x, y, pass == 0, this.field_145850_b.func_72820_D() % 20L == 0L && pass == 1);
                }
            }
        }
    }

    @Override
    public boolean getActive() {
        return super.getActive() || this.produceEnergy();
    }

    @Override
    public FluidTank getWaterTank() {
        return this.water;
    }

    @Override
    public FluidTank getSteamTank() {
        return this.steam;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluidID() == FluidRegistry.WATER.getID()) {
            return this.water.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.steam.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.steam.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("water")) {
            this.water.readFromNBT(nbt.func_74775_l("water"));
        }
        if (nbt.func_74764_b("steam")) {
            this.steam.readFromNBT(nbt.func_74775_l("steam"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound waterTank = new NBTTagCompound();
        this.water.writeToNBT(waterTank);
        nbt.func_74782_a("water", (NBTBase)waterTank);
        NBTTagCompound steamTank = new NBTTagCompound();
        this.steam.writeToNBT(steamTank);
        nbt.func_74782_a("steam", (NBTBase)steamTank);
    }

    @Override
    public float getReactorEnergyOutput() {
        return 0.0f;
    }
}

