/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.ContainerChargedElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.wiring.IElectrolyzerProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCharged
extends TileEntityMachine
implements IHasGui {
    IElectrolyzerProvider[] provider = new IElectrolyzerProvider[6];
    int updateTicker = TileEntityElectrolyzer.randomizer.nextInt(16);
    public int energy = 0;
    public int maxEnergy = 0;

    public TileEntityCharged() {
        super(2);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("Energy");
        this.maxEnergy = nbt.func_74762_e("MaxEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("MaxEnergy", this.maxEnergy);
    }

    @Override
    public String func_145825_b() {
        return "Charged Electrolyzer";
    }

    public IElectrolyzerProvider[] getProviders() {
        IElectrolyzerProvider[] update = new IElectrolyzerProvider[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(tile instanceof IElectrolyzerProvider)) continue;
            update[dir.ordinal()] = (IElectrolyzerProvider)tile;
        }
        return update;
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    private static TileEntityElectrolyzer.ItemRecipe getRecipe(ItemStack par1) {
        return new TileEntityElectrolyzer.ItemRecipe(par1);
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 20000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (itemstack == null) {
            return false;
        }
        if (i == 0) {
            return TileEntityElectrolyzer.charge.containsKey(TileEntityCharged.getRecipe(itemstack));
        }
        if (i == 1) {
            return TileEntityElectrolyzer.discharge.containsKey(TileEntityCharged.getRecipe(itemstack));
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean turnActive = false;
        if (this.updateTicker++ % 16 == 0) {
            this.provider = this.getProviders();
        }
        if (this.shouldDrain() && this.canDrain()) {
            needsInvUpdate = this.drain();
            turnActive = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy > 0)) {
            needsInvUpdate = this.power();
            turnActive = true;
        }
        if (this.getActive() != turnActive) {
            this.setActive(turnActive);
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean power() {
        if (this.energy > 0) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
                if (mfe != null && this.needsEnergy(mfe)) {
                    int speed = Math.min(this.energy, mfe.getProcessRate());
                    mfe.addPower(speed);
                    this.energy -= speed;
                }
                if (this.energy <= 0) break;
            }
            if (this.energy > 0) {
                return false;
            }
        }
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack result = TileEntityElectrolyzer.discharge.get(TileEntityCharged.getRecipe(this.inventory[1])).func_77946_l();
        if (result == null) {
            return false;
        }
        int totalEnergy = TileEntityElectrolyzer.energyNeeds.get(TileEntityCharged.getRecipe(result));
        int base = (int)((double)totalEnergy / 10.0 * 6.0);
        int extra = (int)((double)totalEnergy / 10.0 * (double)this.getHighestMFE());
        this.energy += base + extra;
        this.maxEnergy = (short)(base + extra);
        ItemStack itemStack = this.inventory[1];
        --itemStack.field_77994_a;
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
        if (this.inventory[0] == null) {
            this.inventory[0] = result;
        } else {
            this.inventory[0].field_77994_a += result.field_77994_a;
        }
        return true;
    }

    private int getHighestMFE() {
        int tier = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
            if (mfe == null) continue;
            tier = Math.max(tier, mfe.getTier());
        }
        return tier;
    }

    public boolean canPower() {
        if (this.inventory[1] == null) {
            return false;
        }
        TileEntityElectrolyzer.ItemRecipe item = TileEntityCharged.getRecipe(this.inventory[1]);
        ItemStack result = TileEntityElectrolyzer.discharge.get(item);
        if (result == null) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(result)) {
            return false;
        }
        return this.inventory[0].field_77994_a + result.field_77994_a <= this.inventory[0].func_77976_d();
    }

    public boolean shouldPower() {
        int needsPower = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
            if (mfe == null || !this.needsEnergy(mfe)) continue;
            ++needsPower;
        }
        return needsPower > 0;
    }

    private boolean needsEnergy(IElectrolyzerProvider par1) {
        return (double)par1.getStoredPower() / (double)par1.getMaxStorage() <= 0.3;
    }

    public boolean drain() {
        int req = TileEntityElectrolyzer.energyNeeds.get(TileEntityCharged.getRecipe(this.inventory[0]));
        if (this.maxEnergy != req) {
            this.maxEnergy = (short)req;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
            if (mfe == null || !this.hasPowerAviable(mfe)) continue;
            int needed = Math.min(mfe.getProcessRate(), this.maxEnergy - this.energy);
            mfe.drawPower(needed);
            this.energy += needed;
        }
        if (this.energy >= req) {
            this.energy -= req;
            ItemStack result = TileEntityElectrolyzer.charge.get(TileEntityCharged.getRecipe(this.inventory[0])).func_77946_l();
            ItemStack itemStack = this.inventory[0];
            --itemStack.field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            if (this.inventory[1] == null) {
                this.inventory[1] = result;
            } else {
                this.inventory[1].field_77994_a += result.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean shouldDrain() {
        int couldProvide = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
            if (mfe == null || !this.hasPowerAviable(mfe)) continue;
            ++couldProvide;
        }
        return couldProvide > 0;
    }

    private boolean hasPowerAviable(IElectrolyzerProvider mfe) {
        return (double)mfe.getStoredPower() / (double)mfe.getMaxStorage() >= 0.7;
    }

    public boolean canDrain() {
        if (this.inventory[0] == null) {
            return false;
        }
        TileEntityElectrolyzer.ItemRecipe item = TileEntityCharged.getRecipe(this.inventory[0]);
        ItemStack result = TileEntityElectrolyzer.charge.get(item);
        if (result == null) {
            return false;
        }
        if (TileEntityElectrolyzer.energyNeeds.get(item) > this.getAviablePower()) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(result)) {
            return false;
        }
        return this.inventory[1].field_77994_a + result.field_77994_a <= this.inventory[1].func_77976_d();
    }

    private int getAviablePower() {
        int power = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IElectrolyzerProvider mfe = this.provider[dir.ordinal()];
            if (mfe == null) continue;
            power += mfe.getStoredPower();
        }
        return power;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerChargedElectrolyzer(p0, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiCharged";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }
}

