/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.ContainerIronFurnace;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityIronFurnace
extends TileEntityMachine
implements IHasGui {
    public int fuel = 0;
    public int maxFuel = 0;
    public short progress = 0;
    public short operationLength = (short)160;

    public TileEntityIronFurnace() {
        super(3);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable e) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable e) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 160;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean wasOperating = this.isBurning();
        boolean needsInvUpdate = false;
        if (this.fuel <= 0 && this.canOperate()) {
            int fuelValue;
            this.maxFuel = fuelValue = TileEntityIronFurnace.getFuelValueFor(this.inventory[1]);
            this.fuel = fuelValue;
            if (this.fuel > 0) {
                if (this.inventory[1].func_77973_b().hasContainerItem(this.inventory[1])) {
                    this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                } else {
                    ItemStack itemStack = this.inventory[1];
                    --itemStack.field_77994_a;
                }
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (wasOperating != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        ItemStack itemstack = this.getResultFor(this.inventory[0]);
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack.func_77946_l();
        } else {
            ItemStack itemStack = this.inventory[2];
            itemStack.field_77994_a += itemstack.field_77994_a;
        }
        if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
        } else {
            ItemStack itemStack2 = this.inventory[0];
            --itemStack2.field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = this.getResultFor(this.inventory[0]);
        return itemstack != null && (this.inventory[2] == null || this.inventory[2].func_77969_a(itemstack) && this.inventory[2].field_77994_a + itemstack.field_77994_a <= this.inventory[2].func_77976_d());
    }

    public static int getFuelValueFor(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item itemIndex = itemstack.func_77973_b();
        if (itemIndex == Items.field_151129_at || itemstack.func_77969_a(Ic2Items.lavaCell)) {
            return 2000;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack);
    }

    public ItemStack getResultFor(ItemStack itemstack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
    }

    @Override
    public String func_145825_b() {
        return "Iron Furnace";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerIronFurnace(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiIronFurnace";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        switch (var1) {
            case 1: {
                return new int[]{0};
            }
            case 0: {
                return new int[]{1};
            }
        }
        return new int[]{2};
    }
}

