/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.TileEntityEnergyOMat;
import ic2.core.block.personal.TileEntityFluidOMat;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.block.personal.TileEntityTradeOMat;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPersonal
extends BlockMultiID {
    public static Class tileEntityPersonalChestClass = TileEntityPersonalChest.class;

    public BlockPersonal() {
        super(Material.field_151573_f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IC2.tabIC2);
        this.field_149785_s = false;
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return Ic2Icons.getTexture("bpersonal");
    }

    @Override
    protected int getIconMeta(int meta) {
        return meta;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("personal");
    }

    public boolean func_149662_c() {
        return false;
    }

    public ArrayList getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (IC2.platform.isSimulating() && IC2.platform.isRendering()) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, metadata));
        return ret;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        try {
            switch (meta) {
                case 0: {
                    return (TileEntityBlock)tileEntityPersonalChestClass.newInstance();
                }
                case 1: {
                    return new TileEntityTradeOMat();
                }
                case 2: {
                    return new TileEntityEnergyOMat();
                }
                case 3: {
                    return new TileEntityFluidOMat();
                }
            }
            return new TileEntityBlock();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        int meta = world.func_72805_g(i, j, k);
        TileEntity te = world.func_147438_o(i, j, k);
        return (!IC2.platform.isSimulating() || meta == 1 || meta == 2 || !(te instanceof IPersonalBlock) || ((IPersonalBlock)te).canAccess(entityplayer)) && super.func_149727_a(world, i, j, k, entityplayer, side, a, b, c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 0 ? EnumRarity.uncommon : EnumRarity.common;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        if (entityliving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityliving;
            TileEntity tile = world.func_147438_o(i, j, k);
            if (tile != null && tile instanceof IPersonalBlock) {
                ((IPersonalBlock)tile).canAccess(player);
            }
        }
    }

    @Override
    public void init() {
        Ic2Items.personalSafe = new ItemStack((Block)this, 1, 0);
        Ic2Items.tradeOMat = new ItemStack((Block)this, 1, 1);
        Ic2Items.energyOMat = new ItemStack((Block)this, 1, 2);
        Ic2Items.fluidOMat = new ItemStack((Block)this, 1, 3);
    }
}

