/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.personal.ContainerEnergyOMatClosed;
import ic2.core.block.personal.ContainerEnergyOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.IPersonalInventory;
import ic2.core.block.personal.PersonalInventory;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnergyOMat
extends TileEntityMachine
implements IPersonalBlock,
IHasGui,
IPersonalInventory,
ISidedInventory,
IEnergySink,
IEnergySourceInfo,
INetworkClientTileEntityEventListener {
    private static Direction[] directions = Direction.values();
    public int euOffer = 1000;
    private UUID owner;
    private boolean addedToEnergyNet = false;
    public int paidFor = 0;
    public int euBuffer = 0;
    private int euBufferMax = 10000;
    private int maxOutputRate = 32;
    private PersonalInventory inv = new PersonalInventory(this, "Energy-O-Mat", 2);

    public TileEntityEnergyOMat() {
        super(1);
    }

    @Override
    public String func_145825_b() {
        return "Energy-O-Mat";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.euOffer = nbttagcompound.func_74762_e("euOffer");
        this.paidFor = nbttagcompound.func_74762_e("paidFor");
        this.euBuffer = nbttagcompound.func_74762_e("euBuffer");
        if (nbttagcompound.func_74764_b("PlayerOwner")) {
            NBTTagCompound nbt = nbttagcompound.func_74775_l("PlayerOwner");
            this.owner = new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast"));
        } else {
            this.owner = null;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("euOffer", this.euOffer);
        nbttagcompound.func_74768_a("paidFor", this.paidFor);
        nbttagcompound.func_74768_a("euBuffer", this.euBuffer);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("UUIDMost", this.owner.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.owner.getLeastSignificantBits());
            nbttagcompound.func_74782_a("PlayerOwner", (NBTBase)nbt);
        }
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner == null) {
            this.owner = player.func_146103_bH().getId();
            IC2.network.get().updateTileEntityField(this, "owner");
            return true;
        }
        return this.canAccess(player.func_146103_bH().getId());
    }

    @Override
    public boolean canAccess(UUID player) {
        if (this.owner == null) {
            return true;
        }
        return this.owner.equals(player);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            this.euBufferMax = 10000;
            this.maxOutputRate = 32;
            if (this.inv.func_70301_a(1) != null) {
                if (this.inv.func_70301_a(1).func_77969_a(Ic2Items.energyStorageUpgrade)) {
                    this.euBufferMax = 10000 * (this.inv.func_70301_a((int)1).field_77994_a + 1);
                } else if (this.inv.func_70301_a(1).func_77969_a(Ic2Items.transformerUpgrade)) {
                    this.maxOutputRate = 32 * (int)Math.pow(4.0, Math.min(4, this.inv.func_70301_a((int)1).field_77994_a));
                }
            }
            if (this.inventory[0] != null && this.inv.func_70301_a(0) != null && this.inventory[0].func_77969_a(this.inv.func_70301_a(0))) {
                int originalStackSize = this.inventory[0].field_77994_a;
                for (Direction direction : directions) {
                    TileEntity target = direction.applyToTileEntity(this);
                    if ((!(target instanceof IInventory) || target instanceof IPersonalBlock) && (!(target instanceof TileEntityPersonalChest) || !((TileEntityPersonalChest)target).canAccess(this.owner))) continue;
                    IInventory targetInventory = (IInventory)target;
                    if (target instanceof TileEntityChest) {
                        targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                    }
                    ItemStack stack = this.inventory[0].func_77946_l();
                    int amount = StackUtil.putInInventory(targetInventory, direction, this.owner, stack);
                    stack.field_77994_a -= amount;
                    if (stack.field_77994_a <= 0) {
                        stack = null;
                    }
                    this.inventory[0] = stack;
                }
                int numPaymentMoved = originalStackSize - this.inventory[1].field_77994_a;
                if (numPaymentMoved > 0) {
                    this.paidFor += this.euOffer / this.inventory[0].field_77994_a * numPaymentMoved;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    this.func_70296_d();
                }
            }
            if (this.euBuffer > this.euBufferMax) {
                this.euBuffer = this.euBufferMax;
            }
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && this.canAccess(entityPlayer);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.maxOutputRate, this.euBuffer);
    }

    @Override
    public void drawEnergy(double amount) {
        this.euBuffer = (int)((double)this.euBuffer - amount);
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min(this.paidFor, this.euBufferMax - this.euBuffer);
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        int toAdd = (int)Math.min(Math.min(amount, (double)this.paidFor), (double)(this.euBufferMax - this.euBuffer));
        this.paidFor -= toAdd;
        this.euBuffer += toAdd;
        return amount - (double)toAdd;
    }

    @Override
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return new ContainerEnergyOMatOpen(entityPlayer, this);
        }
        return new ContainerEnergyOMatClosed(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return "block.personal.GuiEnergyOMatOpen";
        }
        return "block.personal.GuiEnergyOMatClosed";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public List getNetworkedFields() {
        List l = super.getNetworkedFields();
        if (this.owner != null) {
            l.add("owner");
        }
        return l;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (!this.canAccess(player)) {
            return;
        }
        switch (event) {
            case 0: {
                this.attemptSet(-1000);
                break;
            }
            case 1: {
                this.attemptSet(-100);
                break;
            }
            case 2: {
                this.attemptSet(1000);
                break;
            }
            case 3: {
                this.attemptSet(100);
            }
        }
    }

    private void attemptSet(int amount) {
        if (this.euOffer + amount <= 0) {
            amount = 0;
        }
        this.euOffer += amount;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.maxOutputRate);
    }

    @Override
    public IPersonalInventory getInventory(EntityPlayer player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.getInventory(player.func_146103_bH().getId());
    }

    @Override
    public IPersonalInventory getInventory(UUID player) {
        if (!this.canAccess(player)) {
            return this;
        }
        return this.inv;
    }

    UUID getOwner() {
        return this.owner;
    }

    @Override
    public int getMaxEnergyAmount() {
        return 8192;
    }
}

