/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.wiring.ContainerBatteryBox;
import ic2.core.block.wiring.IElectrolyzerProvider;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBatteryBox
extends TileEntityMachine
implements IMultiEnergySource,
IEnergySourceInfo,
IEnergySink,
INetworkClientTileEntityEventListener,
IHasGui,
IElectrolyzerProvider {
    public int currentStored;
    public int maxStorage;
    public int currentOutput;
    public int currentInput;
    public int currentChange;
    public int[] batteryTiers = new int[9];
    public int[] stored = new int[9];
    public boolean[] providers = new boolean[9];
    public int[] incomingTicks = new int[20];
    public int[] outputTicks = new int[20];
    public int tick = 0;
    public int currentDraw = 0;
    public int stationMode = 0;
    public static int maxMode = 3;
    public int sendingMode = 0;
    public static int sendingMaxMode = 3;
    public boolean added = false;
    public int state = 0;
    int[] changes = new int[9];

    public TileEntityBatteryBox() {
        super(9);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public List getNetworkedFields() {
        List list = super.getNetworkedFields();
        list.add("state");
        return list;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("state")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public String func_145825_b() {
        return "Battery Box";
    }

    @Override
    public double getOfferedEnergy() {
        return this.getOffer(this.sendingMode);
    }

    @Override
    public void drawEnergy(double amount) {
        int n = this.tick;
        this.outputTicks[n] = (int)((double)this.outputTicks[n] + amount);
        this.currentStored = (int)((double)this.currentStored - amount);
        switch (this.sendingMode) {
            case 0: {
                this.drawFromBattery(this.currentDraw, (int)amount);
                break;
            }
            case 1: {
                this.drawFromAll((int)amount);
                break;
            }
            case 2: {
                this.drawFromBattery(this.currentDraw, (int)amount);
                this.currentDraw = this.getNextID();
            }
        }
    }

    public int getNextID() {
        int id = this.currentDraw;
        boolean found = false;
        for (int i = id + 1; i < 9; ++i) {
            if (!this.providers[i] || this.stored[i] <= 0) continue;
            id = i;
            found = true;
            break;
        }
        if (!found) {
            id = 0;
        }
        return id;
    }

    public void drawFromAll(int amount) {
        for (int i = 0; i < 9; ++i) {
            if (!this.providers[i] || this.stored[i] <= 0) continue;
            int drawn = (int)ElectricItem.manager.discharge(this.func_70301_a(i), Math.min((double)amount, Math.min((double)this.stored[i], EnergyNet.instance.getPowerFromTier(this.batteryTiers[i]))), this.batteryTiers[i], false, true, false);
            int n = i;
            this.stored[n] = this.stored[n] - drawn;
            amount -= drawn;
        }
    }

    public void drawFromBattery(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            ElectricItem.manager.discharge(stack, amount, this.batteryTiers[slot], false, true, false);
            int n = slot;
            this.stored[n] = this.stored[n] - amount;
        }
    }

    @Override
    public int getSourceTier() {
        switch (this.sendingMode) {
            case 0: {
                if (this.currentDraw >= 0) {
                    return this.batteryTiers[this.currentDraw];
                }
            }
            case 1: {
                return EnergyNet.instance.getTierFromPower(this.getOffer(1));
            }
            case 2: {
                return this.batteryTiers[this.currentDraw];
            }
        }
        return 0;
    }

    public int getOffer(int type) {
        if (type == 0) {
            this.currentDraw = -1;
            for (int i = 0; i < 9; ++i) {
                if (!this.providers[i] || this.stored[i] <= 0) continue;
                this.currentDraw = i;
                break;
            }
            if (this.currentDraw >= 0) {
                return (int)Math.min((double)this.stored[this.currentDraw], EnergyNet.instance.getPowerFromTier(this.batteryTiers[this.currentDraw]));
            }
            return 0;
        }
        if (type == 1) {
            int offer = 0;
            for (int i = 0; i < 9; ++i) {
                if (!this.providers[i] || this.stored[i] <= 0) continue;
                offer = (int)((double)offer + Math.min((double)this.stored[i], EnergyNet.instance.getPowerFromTier(this.batteryTiers[i])));
            }
            return offer;
        }
        if (type == 2) {
            int amount;
            if (this.currentDraw == -1) {
                this.currentDraw = 0;
            }
            if ((amount = (int)Math.min((double)this.stored[this.currentDraw], EnergyNet.instance.getPowerFromTier(this.batteryTiers[this.currentDraw]))) <= 0 && this.currentStored > 0) {
                this.currentDraw = this.getNextID();
                amount = (int)Math.min((double)this.stored[this.currentDraw], EnergyNet.instance.getPowerFromTier(this.batteryTiers[this.currentDraw]));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        int mode = this.stationMode;
        return (mode == 1 || mode == 2) && direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return (this.stationMode == 1 || this.stationMode == 2) && this.sendingMode == 2;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        int amount = 0;
        for (int i = 0; i < 9; ++i) {
            if (!this.providers[i]) continue;
            ++amount;
        }
        return amount;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        int mode = this.stationMode;
        return (mode == 0 || mode == 2) && direction.ordinal() != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxStorage - this.currentStored;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double left = this.charge(amount);
        int n = this.tick;
        this.incomingTicks[n] = this.incomingTicks[n] + (int)(amount - left);
        return left;
    }

    public double charge(double amount) {
        double copyAmount = amount;
        for (int i = 0; i < 9 && (int)copyAmount > 0; ++i) {
            copyAmount -= this.charge(i, copyAmount);
        }
        return copyAmount;
    }

    public double charge(int slot, double amount) {
        double copyAmount = amount;
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && (stack.func_77973_b() instanceof IElectricItem || ElectricItem.getBackupManager(stack) != null)) {
            int removed = (int)ElectricItem.manager.charge(stack, (int)amount, this.batteryTiers[slot], false, false);
            copyAmount -= (double)removed;
            int n = slot;
            this.stored[n] = this.stored[n] + removed;
            this.currentStored += removed;
        }
        return amount - copyAmount;
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.recalculate();
    }

    private void recalculate() {
        this.currentStored = 0;
        this.maxStorage = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                this.providers[i] = item.canProvideEnergy(stack);
                this.batteryTiers[i] = item.getTier(stack);
                this.maxStorage = (int)((double)this.maxStorage + item.getMaxCharge(stack));
                int charge = (int)ElectricItem.manager.getCharge(stack);
                this.currentStored += charge;
                this.stored[i] = charge;
                continue;
            }
            this.batteryTiers[i] = 0;
            this.providers[i] = false;
            this.stored[i] = 0;
        }
    }

    @Override
    public void func_145845_h() {
        int newState;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.tick >= 20) {
            this.tick = 0;
            double calculationIn = 0.0;
            double calculationOut = 0.0;
            for (int i = 0; i < 20; ++i) {
                calculationIn += (double)this.incomingTicks[i];
                calculationOut += (double)this.outputTicks[i];
            }
            this.currentOutput = (int)(calculationOut /= 20.0);
            this.currentInput = (int)(calculationIn /= 20.0);
            this.currentChange = (int)(calculationIn - calculationOut);
            IC2.network.get().updateTileEntityField(this, "currentOutput");
            IC2.network.get().updateTileEntityField(this, "currentInput");
            IC2.network.get().updateTileEntityField(this, "currentChange");
            this.incomingTicks = new int[20];
            this.outputTicks = new int[20];
        }
        if (this.field_145850_b.func_72820_D() % 200L == 0L) {
            this.func_70296_d();
        }
        if ((newState = this.getUpdatedState()) != this.state) {
            this.state = newState;
            IC2.network.get().updateTileEntityField(this, "state");
        }
    }

    public void updateEnergyNet(boolean adding) {
        if (adding) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.added = true;
            return;
        }
        if (this.added) {
            this.added = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.added = true;
        }
        this.recalculate();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            this.added = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            this.updateEnergyNet(false);
            ++this.stationMode;
            if (this.stationMode >= maxMode) {
                this.stationMode = 0;
            }
            this.updateEnergyNet(true);
            IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)("container.batteryBoxMode" + this.stationMode + ".name")));
        } else if (event == 1) {
            if (this.stationMode < 1) {
                IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)"container.batteryBoxNothing.name"));
                return;
            }
            ++this.sendingMode;
            if (this.sendingMode >= sendingMaxMode) {
                this.sendingMode = 0;
            }
            IC2.platform.messagePlayer(player, StatCollector.func_74838_a((String)("container.batteryBoxEnergyMode" + this.sendingMode + ".name")));
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerBatteryBox(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.wiring.GuiBatteryBox";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.batteryTiers = nbt.func_74759_k("BatteryTiers");
        this.stored = nbt.func_74759_k("Stored");
        this.currentChange = nbt.func_74762_e("CurrentChange");
        this.currentDraw = nbt.func_74762_e("CurrentDraw");
        this.currentInput = nbt.func_74762_e("CurrentInput");
        this.currentOutput = nbt.func_74762_e("CurrentOutput");
        this.currentStored = nbt.func_74762_e("CurrentStored");
        this.maxStorage = nbt.func_74762_e("MaxStorage");
        this.sendingMode = nbt.func_74762_e("SendingMode");
        this.stationMode = nbt.func_74762_e("StationMode");
        this.injectArray(nbt.func_74770_j("Provider"));
        this.state = nbt.func_74762_e("State");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74783_a("BatteryTiers", this.batteryTiers);
        nbt.func_74783_a("Stored", this.stored);
        nbt.func_74768_a("CurrentChange", this.currentChange);
        nbt.func_74768_a("CurrentDraw", this.currentDraw);
        nbt.func_74768_a("CurrentInput", this.currentInput);
        nbt.func_74768_a("CurrentOutput", this.currentOutput);
        nbt.func_74768_a("CurrentStored", this.currentStored);
        nbt.func_74768_a("MaxStorage", this.maxStorage);
        nbt.func_74768_a("SendingMode", this.sendingMode);
        nbt.func_74768_a("StationMode", this.stationMode);
        nbt.func_74773_a("Provider", this.getProviderInfo());
        nbt.func_74768_a("State", this.state);
    }

    private byte[] getProviderInfo() {
        byte[] data = new byte[9];
        for (int i = 0; i < 9; ++i) {
            data[i] = (byte)(this.providers[i] ? 1 : 0);
        }
        return data;
    }

    private void injectArray(byte[] par1) {
        for (int i = 0; i < 9; ++i) {
            this.providers[i] = par1[i] == 1;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }

    @Override
    public boolean hasTileMeta() {
        return true;
    }

    @Override
    public int getTileMeta() {
        return this.state;
    }

    public float getChargeLevel() {
        float ret = (float)this.currentStored / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public int getUpdatedState() {
        float charge = this.getChargeLevel();
        if ((double)charge <= 0.01) {
            return 0;
        }
        if ((double)charge >= 0.99) {
            return 3;
        }
        if ((double)charge < 0.5) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getProcessRate() {
        int total = 0;
        for (int i = 0; i < this.batteryTiers.length; ++i) {
            int change;
            if (!this.providers[i]) continue;
            this.changes[i] = change = Math.min(this.stored[i], this.getTierFromEnergy(this.batteryTiers[i]));
            total += change;
        }
        return total;
    }

    public int getTierFromEnergy(int i) {
        int amount = (int)(EnergyNet.instance.getPowerFromTier(i) / 16.0);
        if (amount <= 0) {
            return 2;
        }
        return amount;
    }

    @Override
    public int getTier() {
        int maxTier = 1;
        for (int i = 0; i < this.providers.length; ++i) {
            if (!this.providers[i]) continue;
            maxTier = Math.max(maxTier, this.batteryTiers[i]);
        }
        return maxTier;
    }

    @Override
    public void drawPower(int amount) {
        for (int i = 0; i < this.changes.length; ++i) {
            int change = this.changes[i];
            if (change <= 0 || amount <= 0) continue;
            this.drawFromBattery(i, change);
            amount -= change;
            this.currentStored -= change;
        }
    }

    @Override
    public void addPower(int amount) {
        for (int i = 0; i < this.changes.length; ++i) {
            int change = this.changes[i];
            if (change <= 0 || amount <= 0) continue;
            this.charge(i, amount);
            this.currentStored += change;
        }
    }

    @Override
    public int getStoredPower() {
        return this.currentStored;
    }

    @Override
    public int getMaxStorage() {
        return this.maxStorage;
    }

    @Override
    public int getMaxEnergyAmount() {
        return Integer.MAX_VALUE;
    }
}

