/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLuminator
extends TileEntity
implements IEnergySink,
IWrenchable,
INetworkUpdateListener {
    public int energy = 0;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;
    public ItemStack glass = null;
    private boolean firstTick = true;
    public boolean active;

    public TileEntityLuminator(boolean loaded) {
        this.active = loaded;
    }

    public TileEntityLuminator() {
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
        this.active = nbttagcompound.func_74767_n("Active");
        if (nbttagcompound.func_74764_b("Glass")) {
            this.glass = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("Glass"));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
        nbttagcompound.func_74757_a("Active", this.active);
        if (this.glass != null) {
            NBTTagCompound data = new NBTTagCompound();
            this.glass.func_77955_b(data);
            nbttagcompound.func_74782_a("Glass", (NBTBase)data);
        }
    }

    public ItemStack getGlass() {
        return this.glass;
    }

    public void setGlass(ItemStack item) {
        this.glass = item;
        IC2.network.get().updateTileEntityField(this, "glass");
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("glass")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            this.onLoaded();
            this.loaded = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_145845_h() {
        if (this.firstTick) {
            this.firstTick = false;
            if (this.glass != null) {
                IC2.network.get().updateTileEntityField(this, "glass");
            }
        }
        if (this.active && IC2.platform.isSimulating()) {
            ++this.ticker;
            if (this.ticker % 4 == 0) {
                --this.energy;
                if (this.energy <= 0) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.luminator.func_77973_b()), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 3);
                    TileEntityLuminator newLumi = (TileEntityLuminator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    newLumi.glass = this.glass;
                }
            }
        } else if (!this.active && this.energy > 0 && IC2.platform.isSimulating()) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.activeLuminator.func_77973_b()), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 3);
            TileEntityLuminator newLumi = (TileEntityLuminator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            newLumi.glass = this.glass;
            newLumi.energy = this.energy;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return emitter instanceof TileEntityCable && this.canCableConnectFrom(emitter.field_145851_c, emitter.field_145848_d, emitter.field_145849_e);
    }

    @Override
    public double getDemandedEnergy() {
        return this.getMaxEnergy() - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > (double)this.maxInput) {
            return 0.0;
        }
        if (amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.getMaxEnergy()) {
            re = this.energy - this.getMaxEnergy();
            this.energy = this.getMaxEnergy();
        }
        return re;
    }

    @Override
    public int getSinkTier() {
        return EnergyNet.instance.getTierFromPower(this.maxInput);
    }

    public int getMaxEnergy() {
        return 10000;
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (facing) {
            case 0: {
                return x == this.field_145851_c && y == this.field_145848_d + 1 && z == this.field_145849_e;
            }
            case 1: {
                return x == this.field_145851_c && y == this.field_145848_d - 1 && z == this.field_145849_e;
            }
            case 2: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e + 1;
            }
            case 3: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e - 1;
            }
            case 4: {
                return x == this.field_145851_c + 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
            case 5: {
                return x == this.field_145851_c - 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
        }
        return false;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return Ic2Items.luminator.func_77946_l();
    }
}

