/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IScannerItem;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.item.BasicElectricItem;
import ic2.core.util.Util;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemScanner
extends BasicElectricItem
implements IScannerItem {
    public ItemScanner(int index, int t) {
        super(index);
        this.maxCharge = 10000;
        this.transferLimit = 50;
        this.tier = t;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!ElectricItem.manager.use(itemstack, this.getEnergyCost(itemstack), (EntityLivingBase)entityplayer)) {
            return itemstack;
        }
        IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/ODScanner.ogg", true, IC2.audioManager.defaultVolume);
        if (this.searchOreValue(itemstack)) {
            int value = this.getOreValueOfArea(itemstack, world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v));
            IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.scannerResultValue.name", (Object[])new Object[]{value}));
        } else {
            int value = this.getOreValueOfArea(itemstack, world, Util.roundToNegInf(entityplayer.field_70165_t), Util.roundToNegInf(entityplayer.field_70163_u), Util.roundToNegInf(entityplayer.field_70161_v));
            IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"itemInfo.scannerResultDensity.name", (Object[])new Object[]{value}));
        }
        return itemstack;
    }

    protected int valueOfArea(ItemStack stack, World worldObj, int x, int y, int z, int range, boolean oreValue) {
        int totalScore = 0;
        int blocksScanned = 0;
        for (int blockY = y; blockY > 0; --blockY) {
            for (int blockX = x - range; blockX <= x + range; ++blockX) {
                for (int blockZ = z - range; blockZ <= z + range; ++blockZ) {
                    Block blockId = worldObj.func_147439_a(blockX, blockY, blockZ);
                    int metaData = worldObj.func_72805_g(blockX, blockY, blockZ);
                    if (oreValue) {
                        totalScore += this.getOreValue(stack, blockId, metaData);
                    } else if (this.isValuableOre(stack, blockId, metaData)) {
                        ++totalScore;
                    }
                    ++blocksScanned;
                }
            }
        }
        return blocksScanned > 0 ? (int)(1000.0 * (double)totalScore / (double)blocksScanned) : 0;
    }

    @Override
    public int startLayerScan(ItemStack itemStack) {
        return ElectricItem.manager.use(itemStack, 50.0, null) ? 2 : 0;
    }

    @Override
    public boolean isValuableOre(ItemStack par1, Block block, int metaData) {
        return this.getOreValue(par1, block, metaData) > 0;
    }

    @Override
    public int getOreValue(ItemStack par1, Block block, int metaData) {
        if (IC2.valuableOres.containsKey(block)) {
            Map<Integer, Integer> metaMap = IC2.valuableOres.get(block);
            if (metaMap.containsKey(Short.MAX_VALUE)) {
                return metaMap.get(Short.MAX_VALUE);
            }
            if (metaMap.containsKey(metaData)) {
                return metaMap.get(metaData);
            }
        }
        return 0;
    }

    @Override
    public int getOreValueOfArea(ItemStack par1, World world, int x, int y, int z) {
        return this.valueOfArea(par1, world, x, y, z, this.getRange(par1), this.searchOreValue(par1));
    }

    public int getRange(ItemStack par1) {
        return 2;
    }

    public boolean searchOreValue(ItemStack par1) {
        return false;
    }

    public int getEnergyCost(ItemStack par1) {
        return 50;
    }
}

