/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(int index) {
        super(index);
        this.func_77656_e(160);
        this.func_77625_d(1);
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        Block blockId = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (IC2.keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.func_70093_af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.func_70093_af()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (this.canTakeDamage(itemstack, 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (IC2.platform.isSimulating()) {
                    if (IC2.enableLoggingWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                    }
                    Block block = blockId;
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canTakeDamage(itemstack, 200)) {
                            IC2.platform.messagePlayer(entityPlayer, StatCollector.func_74838_a((String)"itemInfo.wrenchToWeak.name"));
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    } else {
                        dropOriginalBlock = world.field_73012_v.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.damage(itemstack, 10, entityPlayer);
                    }
                    ArrayList drops = block.getDrops(world, x, y, z, metaData, 0);
                    if (dropOriginalBlock) {
                        if (drops.isEmpty()) {
                            drops.add(wrenchable.getWrenchDrop(entityPlayer));
                        } else {
                            drops.set(0, wrenchable.getWrenchDrop(entityPlayer));
                        }
                    }
                    for (ItemStack itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.func_147468_f(x, y, z);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
        }
        return false;
    }

    public void damage(ItemStack is, int damage, EntityPlayer player) {
        is.func_77972_a(damage, (EntityLivingBase)player);
    }

    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        return false;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return false;
    }
}

