/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.api.Direction;
import ic2.api.tile.IMachine;
import ic2.core.Ic2Icons;
import ic2.core.block.inventory.filter.BackupItemFilter;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.item.upgrades.BaseMetaUpgrade;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class BasicExportUpgrade
extends BaseMetaUpgrade {
    @Override
    public boolean onTick(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir;
        if (!machine.isProcessing() && this.getWorldTime(machine) % 20L == 0L && (dir = this.getDirection(upgrade)) != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            int added;
            BackupItemFilter filter = new BackupItemFilter(null);
            ItemStack stack = StackUtil.getFromInventory(machine, dir.getInverse(), this.getOwner(upgrade), filter, 1, false);
            if (stack != null && (added = StackUtil.putInInventory(tile, dir, this.getOwner(upgrade), stack)) > 0) {
                StackUtil.getFromInventory(machine, dir.getInverse(), this.getOwner(upgrade), filter, added, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyToTileEntity((TileEntity)machine)) != null && (tile instanceof IInventory || tile instanceof IPersonalBlock)) {
            for (int i = 0; i < results.size(); ++i) {
                ItemStack item = results.get(i);
                if (item == null) continue;
                ItemStack copy = item.func_77946_l();
                copy.field_77994_a = 1;
                int added = StackUtil.putInInventory(tile, dir, this.getOwner(upgrade), copy);
                if (added <= 0) continue;
                item.field_77994_a -= added;
                if (item.field_77994_a > 0) continue;
                results.remove(i);
                break;
            }
        }
    }

    @Override
    public IMachine.UpgradeType getType() {
        return IMachine.UpgradeType.ImportExport;
    }

    @Override
    public String getName() {
        return "basicItemExportUpgrade";
    }

    @Override
    public IIcon getTexture() {
        return Ic2Icons.getTexture("i0")[183];
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }
}

