/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.PacketManager;
import ic2.core.network.packets.IC2Packet;
import ic2.core.network.packets.server.BlockUpdatePacket;
import ic2.core.network.packets.server.ExplosionPacket;
import ic2.core.network.packets.server.FieldUpdatePacket;
import ic2.core.network.packets.server.ItemEventPacket;
import ic2.core.network.packets.server.ItemGuiPacket;
import ic2.core.network.packets.server.TileGuiPacket;
import ic2.core.network.packets.server.TileServerEventPacket;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkManager {
    private int updatePeriod = 2;
    protected static Map<World, HashSet<TileEntityField>> fieldsToUpdateSet = new HashMap<World, HashSet<TileEntityField>>();
    private Map ticksLeftToUpdate = new HashMap();

    public void onTick(World world) {
        int worldTicksLeftToUpdate = !this.ticksLeftToUpdate.containsKey(world) ? 2 : (Integer)this.ticksLeftToUpdate.get(world);
        if (--worldTicksLeftToUpdate == 0) {
            this.sendUpdatePacket(world);
            worldTicksLeftToUpdate = 2;
        }
        this.ticksLeftToUpdate.put(world, worldTicksLeftToUpdate);
    }

    public void updateTileEntityField(TileEntity te, String field) {
        if (!fieldsToUpdateSet.containsKey(te.func_145831_w())) {
            fieldsToUpdateSet.put(te.func_145831_w(), new HashSet());
        }
        Set worldFieldsToUpdateSet = fieldsToUpdateSet.get(te.func_145831_w());
        worldFieldsToUpdateSet.add(new TileEntityField(te, field));
        if (worldFieldsToUpdateSet.size() > 10000) {
            this.sendUpdatePacket(te.func_145831_w());
        }
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        World world = te.func_145831_w();
        TileServerEventPacket packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = te.field_145851_c - (int)entityPlayer.field_70165_t;
            int distanceZ = te.field_145849_e - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                packet = new TileServerEventPacket(te, event);
            }
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        ItemEventPacket packet = new ItemEventPacket(itemStack, event);
        PacketManager.instance.sendToPlayer(packet, player);
    }

    public void announceBlockUpdate(World world, int x, int y, int z) {
        BlockUpdatePacket packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distance = Math.min(Math.abs(x - (int)entityPlayer.field_70165_t), Math.abs(z - (int)entityPlayer.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            if (packet == null) {
                packet = new BlockUpdatePacket(world, x, y, z);
            }
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
        IC2Packet packet = null;
        if (inventory instanceof TileEntity) {
            packet = new TileGuiPacket((TileEntity)inventory, windowId);
        } else if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IHandHeldInventory) {
            packet = new ItemGuiPacket(entityPlayer.field_71071_by.field_70461_c, windowId);
        } else {
            IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
        }
        if (packet != null) {
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
    }

    public void sendUpdatePacket(World world) {
        if (!fieldsToUpdateSet.containsKey(world)) {
            return;
        }
        Set worldFieldsToUpdateSet = fieldsToUpdateSet.get(world);
        if (worldFieldsToUpdateSet.isEmpty()) {
            return;
        }
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            List<FieldData> data = this.createData(world, (EntityPlayer)entityPlayer, worldFieldsToUpdateSet);
            FieldUpdatePacket packet = new FieldUpdatePacket(data, world);
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
        worldFieldsToUpdateSet.clear();
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void sendInitialData(EntityPlayerMP mp, TileEntity tile) {
        if (tile instanceof INetworkDataProvider) {
            for (String key : ((INetworkDataProvider)tile).getNetworkedFields()) {
                this.updateTileEntityField(tile, key);
            }
        }
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        ExplosionPacket packet = new ExplosionPacket(world, x, y, z);
        for (Object player : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
            if (!(entityPlayer.func_70092_e(x, y, z) < 128.0)) continue;
            PacketManager.instance.sendToPlayer(packet, (EntityPlayer)entityPlayer);
        }
        world.func_72908_a(x, y, z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public List<FieldData> createData(World world, EntityPlayer par1, Set<TileEntityField> par2) {
        ArrayList<FieldData> validThings = new ArrayList<FieldData>();
        for (TileEntityField tef : par2) {
            int distance;
            if (tef.te.func_145837_r() || tef.te.func_145831_w() != world || tef.target != null && tef.target != par1 || (distance = Math.min(Math.abs(tef.te.field_145851_c - (int)par1.field_70165_t), Math.abs(tef.te.field_145849_e - (int)par1.field_70161_v))) > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            FieldData data = new FieldData();
            data.x = tef.te.field_145851_c;
            data.y = tef.te.field_145848_d;
            data.z = tef.te.field_145849_e;
            data.fieldName = tef.field;
            data.data = tef.getData();
            validThings.add(data);
        }
        return validThings;
    }

    class TileEntityField {
        TileEntity te;
        String field;
        EntityPlayerMP target = null;

        TileEntityField(TileEntity te, String field) {
            this.te = te;
            this.field = field;
        }

        public Object getData() {
            try {
                Field targetfield = null;
                Class<?> fieldDeclaringClass = this.te.getClass();
                do {
                    try {
                        targetfield = fieldDeclaringClass.getDeclaredField(this.field);
                    }
                    catch (NoSuchFieldException e3) {
                        fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                    }
                } while (targetfield == null && fieldDeclaringClass != null);
                if (targetfield == null) {
                    throw new NoSuchFieldException(this.field);
                }
                targetfield.setAccessible(true);
                return targetfield.get(this.te);
            }
            catch (Exception e) {
                return null;
            }
        }

        TileEntityField(TileEntity te, String field, EntityPlayerMP target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }

    public class FieldData {
        public int x;
        public int y;
        public int z;
        public String fieldName;
        public Object data;
    }
}

