/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ItemIdCounter {
    private int ID;
    private int startID;

    public ItemIdCounter(int StartID) {
        this.startID = this.ID = StartID - 256;
    }

    public ItemIdCounter updateToNextID() {
        ++this.ID;
        return this;
    }

    public int getCurrentID() {
        if (Item.func_150899_d((int)(this.ID + 256)) != null) {
            int end = this.ID + 256;
            throw new IndexOutOfBoundsException("ItemID is already used: " + end);
        }
        return this.ID;
    }

    public int getAndUpdateCurrentID() {
        int cu = this.getCurrentID();
        this.updateToNextID();
        return cu;
    }

    public static int getConfig(Configuration config, String categorie, int defaultID) {
        Property id = config.get(categorie, "Item StartID", defaultID, "StartID for the Items");
        return Integer.parseInt(id.getString());
    }

    public static int getConfig(Configuration config, String name, String categorie, int defaultID) {
        Property id = config.get(categorie, name, defaultID, "StartID for the Items");
        return Integer.parseInt(id.getString());
    }

    public void setEnd(Configuration config, String cat) {
        int endID = this.ID - this.startID;
        int startIDs = this.startID + 256;
        int IDs = this.ID + 256;
        ConfigCategory cot = config.getCategory(cat);
        if (cot != null && cot.containsKey("Item StartID".toLowerCase(Locale.ENGLISH))) {
            Property items = cot.get("Item StartID".toLowerCase(Locale.ENGLISH));
            items.comment = String.format("%s%n%s%n%s", items.comment, "You need to Hold " + endID + " ItemIDs Free", "(From: " + startIDs + " ItemID To: " + IDs + " ItemID)");
            cot.put("Item StartID".toLowerCase(Locale.ENGLISH), items);
        }
    }
}

