/*
 * Decompiled with CFR 0.152.
 */
package ic2.rfIntigration.core.converter;

import ic2.core.IC2;
import ic2.rfIntigration.tiles.IConverterStorage;
import net.minecraft.nbt.NBTTagCompound;

public class RF {
    public int storedRF;

    public void readFromNBT(NBTTagCompound nbt) {
        this.storedRF = nbt.func_74762_e("RF");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("RF", this.storedRF);
    }

    public int charge(int amount, boolean simulate, IConverterStorage storage) {
        int conv = IC2.rfPerEU;
        int copy = amount;
        if (simulate) {
            int storing = this.storedRF;
            if ((storing += amount) >= storage.getFreeSpace() * conv) {
                amount -= storing - storage.getFreeSpace() * conv;
            }
            return copy - amount;
        }
        this.storedRF += amount;
        if (this.storedRF >= storage.getFreeSpace() * conv) {
            amount -= this.storedRF - storage.getFreeSpace() * conv;
            this.storedRF = storage.getFreeSpace() * conv;
        }
        if (this.storedRF >= conv) {
            this.storedRF -= storage.charge(this.storedRF / conv) * conv;
        }
        return copy - amount;
    }

    public int discharge(int amount, boolean simulate, IConverterStorage storage) {
        int conv = IC2.rfForEU;
        if (simulate) {
            int stored = this.storedRF;
            if (stored >= amount) {
                return amount;
            }
            return Math.min(amount, stored += storage.useEnergy(amount / conv + 1, true) * conv);
        }
        if (this.storedRF >= amount) {
            this.storedRF -= amount;
            return amount;
        }
        this.storedRF += storage.useEnergy(amount / conv + 1) * conv;
        this.storedRF -= amount;
        if (this.storedRF < 0) {
            amount += this.storedRF;
            this.storedRF = 0;
        }
        return amount;
    }
}

