/*
 * Decompiled with CFR 0.152.
 */
package ic2.tcIntigration.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.Ic2Items;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import tconstruct.library.modifier.IModifyable;
import tconstruct.modifiers.tools.ModBoolean;

public class EUMofifier
extends ModBoolean {
    public ArrayList<ItemStack> batteries = new ArrayList();

    public EUMofifier() {
        super(new ItemStack[0], 5000, "EUEnergy", EnumChatFormatting.BLUE.toString(), "");
        this.batteries.add(Ic2Items.chargedReBattery);
        this.batteries.add(Ic2Items.reBattery);
        this.batteries.add(Ic2Items.energyCrystal);
        this.batteries.add(Ic2Items.lapotronCrystal);
    }

    public boolean matches(ItemStack[] input, ItemStack tool) {
        String[] traits;
        for (String trait : traits = ((IModifyable)tool.func_77973_b()).getTraits()) {
            if (!"ammo".equals(trait)) continue;
            return false;
        }
        ItemStack foundBattery = null;
        block1: for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null) continue block1;
                if (stack.func_77973_b() != battery.func_77973_b() || !(stack.func_77973_b() instanceof IElectricItem)) continue;
                if (foundBattery != null) {
                    return false;
                }
                foundBattery = stack;
            }
        }
        if (foundBattery == null) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n(this.key)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(tool).func_74775_l(this.key);
            int tier = nbt.func_74762_e("Tier");
            int maxEnergy = nbt.func_74762_e("maxEnergy");
            IElectricItem item = (IElectricItem)foundBattery.func_77973_b();
            return item.getMaxCharge(foundBattery) > (double)maxEnergy && item.getTier(foundBattery) >= tier || item.getMaxCharge(foundBattery) >= (double)maxEnergy && item.getTier(foundBattery) > tier;
        }
        return tags.func_74762_e("Modifiers") >= 1;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        ItemStack foundBattery = null;
        boolean hasModifier = true;
        if (!tags.func_74764_b(this.key)) {
            int modifiers = tags.func_74775_l("InfiTool").func_74762_e("Modifiers");
            tags.func_74775_l("InfiTool").func_74768_a("Modifiers", --modifiers);
            this.addModifierTip(tool, EnumChatFormatting.BLUE + "EU");
            hasModifier = false;
        }
        tags.func_74757_a(this.key, true);
        block0: for (ItemStack stack : input) {
            for (ItemStack battery : this.batteries) {
                if (stack == null) continue block0;
                if (stack.func_77973_b() != battery.func_77973_b() || !(stack.func_77973_b() instanceof IElectricItem)) continue;
                foundBattery = stack;
            }
        }
        NBTTagCompound nbt = null;
        if (tool.func_77978_p().func_74764_b(this.key)) {
            nbt = tool.func_77978_p().func_74775_l("EUEnergy");
        } else {
            tool.func_77978_p().func_74782_a("EUEnergy", (NBTBase)new NBTTagCompound());
            nbt = tool.func_77978_p().func_74775_l("EUEnergy");
        }
        IElectricItem battery = (IElectricItem)foundBattery.func_77973_b();
        int charge = (int)ElectricItem.manager.getCharge(foundBattery);
        if (hasModifier) {
            charge = (int)((double)charge + ElectricItem.manager.getCharge(tool));
        }
        int maxCharge = (int)Math.max(battery.getMaxCharge(foundBattery), (double)nbt.func_74762_e("maxCharge"));
        charge = Math.min(charge, maxCharge);
        int maxTier = Math.max(battery.getTier(foundBattery), nbt.func_74762_e("Tier"));
        int limit = (int)Math.max(battery.getTransferLimit(foundBattery), (double)nbt.func_74762_e("limit"));
        nbt.func_74768_a("maxCharge", maxCharge);
        nbt.func_74768_a("Tier", maxTier);
        nbt.func_74768_a("limit", limit);
        ElectricItem.manager.charge(tool, charge, Integer.MAX_VALUE, true, false);
    }

    public boolean validType(IModifyable input) {
        return super.validType(input);
    }
}

