/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.Direction;
import ic2classic.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import java.util.List;
import mods.immibis.redlogic.api.wiring.IBareRedstoneWire;
import mods.immibis.redlogic.api.wiring.IBundledEmitter;
import mods.immibis.redlogic.api.wiring.IBundledWire;
import mods.immibis.redlogic.api.wiring.IConnectable;
import mods.immibis.redlogic.api.wiring.IWire;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.lib.api.tile.IBattery;
import pl.asie.lib.api.tile.IBundledRedstoneProvider;
import pl.asie.lib.api.tile.IInformationProvider;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.block.TileEntityBase;
import pl.asie.lib.reference.Mods;
import pl.asie.lib.util.EnergyConverter;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IConnectable", modid="RedLogic")})
public class TileMachine
extends TileEntityBase
implements IConnectable,
ISidedInventory {
    private IBattery battery;
    private IBundledRedstoneProvider brP;
    private ItemStack[] items;
    private boolean didInitIC2 = false;
    private boolean didInitIC2C = false;

    public IBattery getBatteryProvider() {
        return this.battery;
    }

    public IBundledRedstoneProvider getBundledRedstoneProvider() {
        return this.brP;
    }

    protected void registerBundledRedstone(IBundledRedstoneProvider brP) {
        this.brP = brP;
    }

    protected void registerBattery(IBattery p) {
        this.battery = p;
    }

    protected void createInventory(int slots) {
        this.items = new ItemStack[slots];
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (Mods.isLoaded("IC2") && this.battery != null) {
            this.initIC();
        }
        if (Mods.isLoaded("IC2-Classic") && this.battery != null) {
            this.initICClassic();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.isLoaded("IC2") && this.battery != null) {
            this.deinitIC();
        }
        if (Mods.isLoaded("IC2-Classic") && this.battery != null) {
            this.deinitICClassic();
        }
    }

    @Optional.Method(modid="RedLogic")
    public boolean connects(IWire wire, int blockFace, int fromDirection) {
        if (wire instanceof IBareRedstoneWire && this.field_145854_h != null && ((BlockBase)this.field_145854_h).emitsRedstone((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, fromDirection)) {
            return true;
        }
        if (wire instanceof IBundledWire) {
            if (this.brP != null) {
                return this.brP.canBundledConnectTo(fromDirection, blockFace);
            }
            return false;
        }
        return false;
    }

    @Optional.Method(modid="RedLogic")
    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return false;
    }

    @Optional.Method(modid="RedLogic")
    public void onBundledInputChanged() {
        if (this.brP != null) {
            block0: for (int side = 0; side < 6; ++side) {
                IBundledEmitter be = null;
                for (int face = -1; face < 6; ++face) {
                    if (!this.brP.canBundledConnectTo(side, face)) continue;
                    if (be == null) {
                        ForgeDirection fd = ForgeDirection.values()[side];
                        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
                        if (t == null || !(t instanceof IBundledEmitter)) continue block0;
                        be = (IBundledEmitter)t;
                    }
                    this.brP.onBundledInputChange(side, face, be.getBundledCableStrength(face, side));
                }
            }
        }
    }

    @Optional.Method(modid="RedLogic")
    public byte[] getBundledCableStrength(int blockFace, int toDirection) {
        if (this.brP != null && this.brP.canBundledConnectTo(toDirection, blockFace)) {
            return this.brP.getBundledOutput(toDirection, blockFace);
        }
        return null;
    }

    @Optional.Method(modid="ProjRed|Core")
    public byte[] getBundledSignal(int side) {
        if (this.brP != null && this.brP.canBundledConnectTo(side, -1)) {
            return this.brP.getBundledOutput(side, -1);
        }
        return null;
    }

    @Optional.Method(modid="ProjRed|Core")
    public boolean canConnectBundled(int side) {
        return this.brP.canBundledConnectTo(side, -1);
    }

    @Optional.Method(modid="ProjRed|Core")
    public void onProjectRedBundledInputChanged() {
        if (this.brP != null) {
            for (int i = 0; i < 6; ++i) {
                byte[] data;
                if (!this.brP.canBundledConnectTo(i, -1) || (data = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i)) == null) continue;
                this.brP.onBundledInputChange(i, -1, data);
            }
        }
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public void onSlotUpdate(int slot) {
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.items != null && this.items[slot] != null) {
            if (this.items[slot].field_77994_a <= amount) {
                ItemStack stack = this.items[slot];
                this.items[slot] = null;
                this.onSlotUpdate(slot);
                return stack;
            }
            ItemStack stack = this.items[slot].func_77979_a(amount);
            if (this.items[slot].field_77994_a == 0) {
                this.items[slot] = null;
            }
            this.onSlotUpdate(slot);
            return stack;
        }
        return null;
    }

    public String func_145825_b() {
        return this.field_145854_h != null ? this.field_145854_h.func_149739_a() + ".inventory" : null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        if (this.items != null) {
            return this.items.length;
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.items != null && slot >= 0 && slot < this.items.length) {
            return this.items[slot];
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items != null && slot >= 0 && slot < this.items.length) {
            ItemStack is = this.func_70301_a(slot);
            this.func_70299_a(slot, null);
            return is;
        }
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.items != null && slot >= 0 && slot < this.items.length;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.items != null && slot >= 0 && slot < this.items.length) {
            this.items[slot] = stack;
            this.onSlotUpdate(slot);
        }
    }

    public boolean func_102008_b(int arg0, ItemStack arg1, int arg2) {
        return true;
    }

    public boolean func_102007_a(int arg0, ItemStack arg1, int arg2) {
        return true;
    }

    public int[] func_94128_d(int arg0) {
        if (this.items == null) {
            return new int[0];
        }
        int[] slots = new int[this.items.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.battery != null) {
            return this.battery.canInsert(from.ordinal(), "RF");
        }
        return false;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.battery.canInsert(from.ordinal(), "RF")) {
            return (int)Math.floor(this.battery.insert(from.ordinal(), maxReceive, simulate));
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.battery.canExtract(from.ordinal(), "RF")) {
            return (int)Math.floor(this.battery.extract(from.ordinal(), maxExtract, simulate));
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.battery != null) {
            return (int)Math.floor(this.battery.getEnergyStored());
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.battery != null) {
            return (int)Math.floor(this.battery.getMaxEnergyStored());
        }
        return 0;
    }

    @Optional.Method(modid="IC2")
    public void initIC() {
        if (!(this.didInitIC2 || this.field_145850_b != null && this.field_145850_b.field_72995_K)) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((ic2.api.energy.tile.IEnergyTile)this));
        }
        this.didInitIC2 = true;
    }

    @Optional.Method(modid="IC2")
    public void deinitIC() {
        if (this.didInitIC2 && (this.field_145850_b == null || !this.field_145850_b.field_72995_K)) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((ic2.api.energy.tile.IEnergyTile)this));
        }
        this.didInitIC2 = false;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (this.battery != null) {
            return this.battery.canInsert(direction.ordinal(), "EU");
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.battery != null) {
            double amountRF = EnergyConverter.convertEnergy(amount, "EU", "RF");
            double injectedRF = this.battery.insert(directionFrom.ordinal(), amountRF, false);
            return amount - EnergyConverter.convertEnergy(injectedRF, "RF", "EU");
        }
        return amount;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (this.battery != null) {
            return EnergyConverter.convertEnergy(this.battery.getMaxEnergyInserted(), "RF", "EU");
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @Optional.Method(modid="IC2-Classic")
    private void initICClassic() {
        if (!this.didInitIC2C) {
            MinecraftForge.EVENT_BUS.post((Event)new ic2classic.api.energy.event.EnergyTileLoadEvent((IEnergyTile)this));
        }
        this.didInitIC2C = true;
    }

    @Optional.Method(modid="IC2-Classic")
    private void deinitICClassic() {
        if (this.didInitIC2C) {
            MinecraftForge.EVENT_BUS.post((Event)new ic2classic.api.energy.event.EnergyTileUnloadEvent((IEnergyTile)this));
        }
        this.didInitIC2C = false;
    }

    @Optional.Method(modid="IC2-Classic")
    public boolean acceptsEnergyFrom(TileEntity arg0, Direction arg1) {
        if (this.battery != null) {
            return this.battery.canInsert(arg1.toSideValue(), "EU");
        }
        return false;
    }

    @Optional.Method(modid="IC2-Classic")
    public boolean isAddedToEnergyNet() {
        return this.didInitIC2C;
    }

    @Optional.Method(modid="IC2-Classic")
    public int demandsEnergy() {
        if (this.battery != null) {
            return (int)Math.floor(EnergyConverter.convertEnergy(this.battery.getMaxEnergyInserted(), "RF", "EU"));
        }
        return 0;
    }

    @Optional.Method(modid="IC2-Classic")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Optional.Method(modid="IC2-Classic")
    public int injectEnergy(Direction arg0, int amount) {
        if (this.battery != null) {
            double amountRF = EnergyConverter.convertEnergy(amount, "EU", "RF");
            double injectedRF = this.battery.insert(arg0.toSideValue(), amountRF, false);
            return amount - (int)Math.floor(EnergyConverter.convertEnergy(injectedRF, "RF", "EU"));
        }
        return amount;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this.battery != null) {
            this.battery.readFromNBT(tagCompound);
        }
        if (this.items != null) {
            NBTTagList nbttaglist = tagCompound.func_150295_c("Inventory", 10);
            this.items = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.items.length) continue;
                this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.battery != null) {
            this.battery.writeToNBT(tagCompound);
        }
        if (this.items != null) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack stack = this.items[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }
    }

    public void removeFromNBTForTransfer(NBTTagCompound data) {
        data.func_82580_o("Inventory");
        data.func_82580_o("bb_energy");
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyPerTick() {
        if (this.battery != null) {
            return (int)Math.round(this.battery.getEnergyUsage());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyPerTick() {
        if (this.battery != null) {
            return (int)Math.round(this.battery.getMaxEnergyUsage());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoEnergyStored() {
        if (this.battery != null) {
            return (int)Math.round(this.battery.getEnergyStored());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public int getInfoMaxEnergyStored() {
        if (this.battery != null) {
            return (int)Math.round(this.battery.getMaxEnergyStored());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|tileentity")
    public void getTileInfo(List<IChatComponent> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (this instanceof IInformationProvider) {
            IInformationProvider p = (IInformationProvider)((Object)this);
            ArrayList<String> data = new ArrayList<String>();
            p.getInformation(player, side, data, debug);
            for (String s : data) {
                info.add((IChatComponent)new ChatComponentText(s));
            }
        }
    }

    @Optional.Method(modid="gregtech")
    public boolean isGivingInformation() {
        return this instanceof IInformationProvider;
    }

    @Optional.Method(modid="gregtech")
    public String[] getInfoData() {
        if (this instanceof IInformationProvider) {
            IInformationProvider p = (IInformationProvider)((Object)this);
            ArrayList<String> data = new ArrayList<String>();
            p.getInformation(null, ForgeDirection.UNKNOWN, data, false);
            return data.toArray(new String[data.size()]);
        }
        return new String[0];
    }
}

