/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_AXE = "Axe";
    public static final String AXE_ENERGY_CONSUMPTION = "Axe Energy Consumption";
    public static final String AXE_HARVEST_SPEED = "Axe Harvest Speed";
    public static final String AXE_SEARCH_RADIUS = "Axe Search Radius";
    private static final Set HarvestableMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151582_l, Material.field_151585_k, Material.field_151570_A, Material.field_151572_C});

    public AxeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(AXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(AXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", AXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", AXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_AXE;
    }

    @Override
    public String getUnlocalizedName() {
        return "axe";
    }

    @Override
    public String getDescription() {
        return "Axes are mostly for chopping trees.";
    }

    @Override
    public String getTextureFile() {
        return "toolaxe";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return (Items.field_151036_c.canHarvestBlock(block, stack) || HarvestableMaterials.contains(block.func_149688_o())) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            double energyConsumption = ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION);
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), AXE_HARVEST_SPEED));
    }
}

