/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import java.util.Random;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FlintAndSteelModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_FLINT_AND_STEEL = "Flint and Steel";
    public static final String IGNITION_ENERGY_CONSUMPTION = "Ignition Energy Consumption";
    public ItemStack fas = new ItemStack(Items.field_151033_d);
    Random ran = new Random();

    public FlintAndSteelModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 1));
        this.addInstallCost(this.fas);
        this.addBaseProperty(IGNITION_ENERGY_CONSUMPTION, 1000.0, "J");
    }

    @Override
    public String getTextureFile() {
        return null;
    }

    @Override
    public IIcon getIcon(ItemStack item) {
        return this.fas.func_77954_c();
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_FLINT_AND_STEEL;
    }

    @Override
    public String getUnlocalizedName() {
        return "flintAndSteel";
    }

    @Override
    public String getDescription() {
        return "A portable igniter that creates fire through the power of energy.";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block clickedBlock;
        double energyConsumption = ModuleManager.computeModularProperty(itemStack, IGNITION_ENERGY_CONSUMPTION);
        if (energyConsumption < ElectricItemUtils.getPlayerEnergy(player) && player.func_82247_a(x += side == 5 ? 1 : (side == 4 ? -1 : 0), y += side == 1 ? 1 : (side == 0 ? -1 : 0), z += side == 3 ? 1 : (side == 2 ? -1 : 0), side, itemStack) && (clickedBlock = world.func_147439_a(x, y, z)) == Blocks.field_150350_a) {
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, this.ran.nextFloat() * 0.4f + 0.8f);
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

