/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class OmniProbeModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    public static final String MODULE_OMNIPROBE = "Prototype OmniProbe";
    private ItemStack conduitProbe;
    private ItemStack rednetMeter;
    private ItemStack cpmPSD;
    private ItemStack rcMeter;
    private ItemStack prDebugger;

    public OmniProbeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 4));
        ItemStack tHighest = GameRegistry.findItemStack((String)"minecraft", (String)"comparator", (int)1);
        if (ModCompatibility.isMFRLoaded()) {
            tHighest = this.rednetMeter = GameRegistry.findItemStack((String)"MineFactoryReloaded", (String)"rednet.meter", (int)1);
        }
        if (ModCompatibility.isRailcraftLoaded()) {
            tHighest = this.rcMeter = GameRegistry.findItemStack((String)"Railcraft", (String)"tool.electric.meter", (int)1);
        }
        if (ModCompatibility.isEnderIOLoaded()) {
            tHighest = this.conduitProbe = GameRegistry.findItemStack((String)"EnderIO", (String)"itemConduitProbe", (int)1);
        }
        this.addInstallCost(tHighest);
    }

    @Override
    public String getTextureFile() {
        return "omniprobe";
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_OMNIPROBE;
    }

    @Override
    public String getUnlocalizedName() {
        return "omniProbe";
    }

    @Override
    public String getDescription() {
        return "A prototype multi-use probe integrated into your power tool.";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int block = Block.func_149682_b((Block)world.func_147439_a(x, y, z));
        if (Loader.isModLoaded((String)"MineFactoryReloaded") && block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"MineFactoryReloaded", (String)"cable.redstone"))) {
            return this.rednetMeter.func_77973_b().onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (Loader.isModLoaded((String)"Railcraft") && (block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.machine.alpha")) || block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.track")) || block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.machine.epsilon")) || block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.machine.delta")))) {
            return this.rcMeter.func_77973_b().onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        if (Loader.isModLoaded((String)"EnderIO") && block == Block.func_149682_b((Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockConduitBundle"))) {
            return this.conduitProbe.func_77973_b().func_77648_a(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!MuseItemUtils.getEIOFacadeTransparency(item)) {
            MuseItemUtils.setEIONoCompete(item, MODULE_OMNIPROBE);
            MuseItemUtils.setEIOFacadeTransparency(item, true);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (MuseItemUtils.getEIONoCompete(item) != null && !MuseItemUtils.getEIONoCompete(item).isEmpty()) {
            if (MuseItemUtils.getEIONoCompete(item).equals(MODULE_OMNIPROBE)) {
                MuseItemUtils.setEIONoCompete(item, "");
                if (MuseItemUtils.getEIOFacadeTransparency(item)) {
                    MuseItemUtils.setEIOFacadeTransparency(item, false);
                }
            }
        } else if (MuseItemUtils.getEIOFacadeTransparency(item)) {
            MuseItemUtils.setEIOFacadeTransparency(item, false);
        }
    }

    public float minF(float a, float b) {
        return a < b ? a : b;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

