/*
 * Decompiled with CFR 0.152.
 */
package kcauldron;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;
import kcauldron.KLog;
import org.spigotmc.RestartCommand;

public class KCauldron {
    private static boolean sManifestParsed = false;
    private static String sCurrentVersion;
    private static File sServerLocation;
    private static File sServerHome;
    private static String sGroup;
    private static String sBranch;
    private static String sChannel;
    public static File sNewServerLocation;
    public static String sNewServerVersion;
    public static boolean sUpdateInProgress;
    private static int sForgeRevision;

    private static void parseManifest() {
        if (sManifestParsed) {
            return;
        }
        sManifestParsed = true;
        try {
            Enumeration<URL> resources = KCauldron.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            Properties manifest = new Properties();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                manifest.load(url.openStream());
                String version = manifest.getProperty("KCauldron-Version");
                if (version != null) {
                    String path = url.getPath();
                    String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
                    jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
                    sServerLocation = new File(jarFilePath);
                    sCurrentVersion = version;
                    sGroup = manifest.getProperty("KCauldron-Group");
                    sBranch = manifest.getProperty("KCauldron-Branch");
                    sChannel = manifest.getProperty("KCauldron-Channel");
                    break;
                }
                manifest.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCurrentVersion() {
        KCauldron.parseManifest();
        return sCurrentVersion;
    }

    public static File getServerLocation() {
        KCauldron.parseManifest();
        return sServerLocation;
    }

    public static File getServerHome() {
        if (sServerHome == null) {
            String home = System.getenv("KCAULDRON_HOME");
            if (home != null) {
                sServerHome = new File(home);
            } else {
                KCauldron.parseManifest();
                sServerHome = sServerLocation.getParentFile();
            }
        }
        return sServerHome;
    }

    public static String getGroup() {
        KCauldron.parseManifest();
        return sGroup;
    }

    public static String getBranch() {
        KCauldron.parseManifest();
        return sBranch;
    }

    public static String getChannel() {
        KCauldron.parseManifest();
        return sChannel;
    }

    public static void restart() {
        RestartCommand.restart(true);
    }

    public static int lookupForgeRevision() {
        if (sForgeRevision != 0) {
            return sForgeRevision;
        }
        int revision = Integer.parseInt(System.getProperty("kcauldron.forgeRevision", "0"));
        if (revision != 0) {
            sForgeRevision = revision;
            return sForgeRevision;
        }
        try {
            Properties p = new Properties();
            p.load(KCauldron.class.getResourceAsStream("/fmlversion.properties"));
            revision = Integer.parseInt(String.valueOf(p.getProperty("fmlbuild.build.number", "0")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (revision == 0) {
            KLog.get().warning("KCauldron: could not parse forge revision, critical error", new Object[0]);
            FMLCommonHandler.instance().exitJava(1, false);
        }
        sForgeRevision = revision;
        return sForgeRevision;
    }

    static {
        sForgeRevision = 0;
    }
}

