/*
 * Decompiled with CFR 0.152.
 */
package kcauldron.updater;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kcauldron.KCauldron;
import kcauldron.updater.DefaultUpdateCallback;
import kcauldron.updater.KVersionRetriever;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandSenderUpdateCallback
implements KVersionRetriever.IVersionCheckCallback {
    private Reference<CommandSender> mSender;

    public CommandSenderUpdateCallback(CommandSender sender) {
        this.mSender = new WeakReference<CommandSender>(sender);
    }

    protected CommandSender getSender() {
        return this.mSender.get();
    }

    @Override
    public void upToDate() {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Running version of KCauldron is up-to-date: " + KCauldron.getCurrentVersion());
        }
        DefaultUpdateCallback.INSTANCE.upToDate();
    }

    @Override
    public void newVersion(String newVersion) {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            CommandSenderUpdateCallback.newVersion(sender, KCauldron.getCurrentVersion(), newVersion);
        }
        DefaultUpdateCallback.INSTANCE.newVersion(newVersion);
    }

    public static void newVersion(CommandSender sender, String currentVersion, String newVersion) {
        sender.sendMessage(new String[]{(Object)((Object)ChatColor.YELLOW) + "Found new version of KCauldron: " + newVersion, (Object)((Object)ChatColor.YELLOW) + "Current is " + currentVersion, (Object)((Object)ChatColor.YELLOW) + "Type '" + (Object)((Object)ChatColor.BLUE) + "/kc update" + (Object)((Object)ChatColor.YELLOW) + "' to update"});
    }

    @Override
    public void error(Throwable t) {
        CommandSender sender = this.mSender.get();
        if (sender != null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Error ocurred durring version check, see details in server log");
        }
    }
}

