/*
 * Decompiled with CFR 0.152.
 */
package kcauldron.updater;

import kcauldron.KCauldron;
import kcauldron.updater.CommandSenderUpdateCallback;
import kcauldron.updater.KCauldronUpdater;
import kcauldron.updater.KVersionRetriever;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;

public class DefaultUpdateCallback
implements KVersionRetriever.IVersionCheckCallback {
    public static DefaultUpdateCallback INSTANCE = new DefaultUpdateCallback();
    private boolean mHasUpdate;
    private String mCurrentVersion;
    private String mNewVersion;

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.mHasUpdate && this.hasPermission(player)) {
            this.sendUpdate(player);
        }
    }

    private boolean hasPermission(CommandSender player) {
        return player.hasPermission("kc.update");
    }

    private void sendUpdate(CommandSender player) {
        CommandSenderUpdateCallback.newVersion(player, this.mCurrentVersion, this.mNewVersion);
    }

    private DefaultUpdateCallback() {
    }

    @Override
    public void upToDate() {
        this.mHasUpdate = false;
        this.mCurrentVersion = KCauldron.getCurrentVersion();
        this.mNewVersion = null;
    }

    @Override
    public void newVersion(String newVersion) {
        this.mCurrentVersion = KCauldron.getCurrentVersion();
        this.mNewVersion = newVersion;
        if (!this.mHasUpdate) {
            Bukkit.getConsoleSender().sendMessage("New version of KCauldron avaiable: " + newVersion);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.hasPermission(player)) continue;
                this.sendUpdate(player);
            }
        }
        this.mHasUpdate = true;
        if (MinecraftServer.kcauldronConfig.updatecheckerAutoinstall.getValue().booleanValue() && !this.mNewVersion.equals(KCauldron.sNewServerVersion) && !KCauldron.sUpdateInProgress) {
            Bukkit.getConsoleSender().sendMessage("Triggering auto update");
            KCauldronUpdater.initUpdate(Bukkit.getConsoleSender(), newVersion);
        }
    }

    @Override
    public void error(Throwable t) {
    }
}

