/*
 * Decompiled with CFR 0.152.
 */
package kcauldron.updater;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import kcauldron.KCauldron;
import kcauldron.updater.CommandSenderUpdateCallback;
import kcauldron.updater.KVersionRetriever;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class KCauldronUpdater
implements Runnable,
KVersionRetriever.IVersionCheckCallback {
    private final CommandSender mSender;
    private final String mVersion;
    private final Thread mThread;

    public static void initUpdate(CommandSender sender, String version) {
        if (KCauldron.sUpdateInProgress) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Update stopped: another update in progress");
            return;
        }
        KCauldron.sUpdateInProgress = true;
        if (version == null) {
            sender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Fetching latest version...");
            KVersionRetriever.startServer(new LatestVersionCallback(sender), false);
        } else {
            KCauldronUpdater.startUpdate(sender, version);
        }
    }

    private static void startUpdate(CommandSender sender, String version) {
        if (sender != null) {
            sender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Starting update to " + version + "...");
        }
        new KCauldronUpdater(sender, version);
    }

    public KCauldronUpdater(CommandSender sender, String version) {
        this.mSender = sender;
        this.mVersion = version;
        this.mThread = new Thread(this);
        this.mThread.setName("KCauldron updater");
        this.mThread.setPriority(1);
        this.mThread.start();
    }

    @Override
    public void run() {
        if (!MinecraftServer.kcauldronConfig.updatecheckerQuite.getValue().booleanValue()) {
            this.mSender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Retrieving latest KBootstrap version...");
        }
        new KVersionRetriever(this, false, false, "pw.prok", "KBootstrap");
    }

    @Override
    public void upToDate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void newVersion(String kbootstrapVersion) {
        boolean quite = MinecraftServer.kcauldronConfig.updatecheckerQuite.getValue();
        try {
            String[] symlinks;
            if (!quite) {
                this.mSender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Downloading KBootstrap " + kbootstrapVersion + "...");
            }
            File kbootstrap = File.createTempFile("kbootstrap", String.valueOf(System.currentTimeMillis()));
            KCauldronUpdater.download("https://api.prok.pw/repo/blob/pw.prok/KBootstrap/latest/app", kbootstrap);
            if (!quite) {
                this.mSender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Installing KCauldron " + this.mVersion + " via KBootstrap " + kbootstrapVersion + "...");
            }
            String javahome = System.getProperty("java.home");
            String javapath = javahome + "/bin/java";
            ArrayList<String> command = new ArrayList<String>();
            command.add(javapath);
            command.add("-jar");
            command.add(kbootstrap.getCanonicalPath());
            command.add("--serverDir");
            command.add(KCauldron.getServerHome().getCanonicalPath());
            command.add("--installKCauldron");
            command.add(String.format("%s:%s:%s", KCauldron.getGroup(), KCauldron.getChannel(), this.mVersion));
            for (String symlink : symlinks = MinecraftServer.kcauldronConfig.updatecheckerSymlinks.getValue().trim().split(File.pathSeparator)) {
                command.add("--serverSymlinks");
                command.add(symlink);
            }
            Bukkit.getConsoleSender().sendMessage("Starting command: " + Joiner.on((char)' ').join(command));
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.environment().put("JAVA_HOME", javahome);
            switch (builder.start().waitFor()) {
                case 0: {
                    this.mSender.sendMessage((Object)((Object)ChatColor.GREEN) + "KCauldron " + this.mVersion + " installed");
                    return;
                }
                default: {
                    this.mSender.sendMessage((Object)((Object)ChatColor.RED) + "Failed to install KCauldron " + this.mVersion);
                    return;
                }
            }
        }
        catch (Exception e) {
            if (!quite) {
                e.printStackTrace();
            }
            if (this.mSender == null) return;
            this.mSender.sendMessage((Object)((Object)ChatColor.RED) + "Failed update to " + this.mVersion);
            return;
        }
        finally {
            KCauldron.sUpdateInProgress = false;
        }
    }

    @Override
    public void error(Throwable t) {
        KCauldron.sUpdateInProgress = false;
        t.printStackTrace();
    }

    private static void download(String url, File destination) throws IOException {
        HttpUriRequest request = RequestBuilder.get().setUri(url).addParameter("hostname", MinecraftServer.I().y()).addParameter("port", String.valueOf(MinecraftServer.I().z())).build();
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setUserAgent("KCauldron Updater").build();
        CloseableHttpResponse response = client.execute(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            client.close();
            throw new IllegalStateException("Could not download " + url);
        }
        InputStream is = response.getEntity().getContent();
        FileOutputStream os = new FileOutputStream(destination);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        is.close();
        ((OutputStream)os).close();
        client.close();
    }

    private static final class LatestVersionCallback
    extends CommandSenderUpdateCallback {
        public LatestVersionCallback(CommandSender sender) {
            super(sender);
        }

        @Override
        public void newVersion(String newVersion) {
            KCauldronUpdater.startUpdate(this.getSender(), newVersion);
        }

        @Override
        public void upToDate() {
            KCauldron.sUpdateInProgress = false;
            CommandSender sender = this.getSender();
            if (sender != null) {
                sender.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "Current version (" + KCauldron.getCurrentVersion() + ") is up to date");
            }
        }

        @Override
        public void error(Throwable t) {
            super.error(t);
            KCauldron.sUpdateInProgress = false;
        }
    }
}

