/*
 * Decompiled with CFR 0.152.
 */
package kcauldron.wrapper;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LinkedHelper<T> {
    private Iterable<T> mIterable;
    private Iterator<T> mIterator;
    private int iteratorIndex;
    private T indexValue;

    public LinkedHelper(Iterable<T> iterable) {
        this.mIterable = iterable;
    }

    public T get(int index) {
        if (this.iteratorIndex > index || this.mIterator == null) {
            this.mIterator = this.mIterable.iterator();
            this.iteratorIndex = -1;
        }
        while (this.iteratorIndex < index) {
            if (this.mIterator.hasNext()) {
                this.indexValue = this.mIterator.next();
                ++this.iteratorIndex;
                continue;
            }
            throw new IndexOutOfBoundsException();
        }
        return this.indexValue;
    }

    public int indexOf(Object o) {
        int i = 0;
        for (T value : this.mIterable) {
            if (o == null ? value == null : o.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (!(this.mIterable instanceof List)) {
            throw new UnsupportedOperationException();
        }
        ListIterator iterator = ((List)this.mIterable).listIterator();
        int i = 0;
        while (iterator.hasPrevious()) {
            Object value = iterator.previous();
            if (o == null ? value == null : o.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ListIterator<T> listIterator() {
        if (this.mIterable instanceof List) {
            return ((List)this.mIterable).listIterator();
        }
        return new LinkedListIterator<T>(this.mIterable.iterator(), 0);
    }

    public ListIterator<T> listIterator(int index) {
        if (this.mIterable instanceof List) {
            return ((List)this.mIterable).listIterator(index);
        }
        Iterator<T> iterator = this.mIterable.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return new LinkedListIterator<T>(iterator, index);
    }

    private static final class LinkedListIterator<T>
    implements ListIterator<T> {
        private final Iterator<T> mIterator;
        private final ListIterator<T> mListIterator;
        private int mNextIndex;

        public LinkedListIterator(Iterator<T> iterator, int index) {
            this.mIterator = iterator;
            this.mListIterator = iterator instanceof ListIterator ? (ListIterator)iterator : null;
            this.mNextIndex = index;
        }

        private void ensureListIterator() {
            if (this.mListIterator == null) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public void add(T e) {
            this.ensureListIterator();
            this.mListIterator.add(e);
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            this.ensureListIterator();
            return this.mListIterator.hasPrevious();
        }

        @Override
        public T next() {
            ++this.mNextIndex;
            return this.mIterator.next();
        }

        @Override
        public int nextIndex() {
            return this.mNextIndex;
        }

        @Override
        public T previous() {
            this.ensureListIterator();
            return this.mListIterator.previous();
        }

        @Override
        public int previousIndex() {
            this.ensureListIterator();
            return this.mListIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.ensureListIterator();
            this.mListIterator.remove();
        }

        @Override
        public void set(T e) {
            this.ensureListIterator();
            this.mListIterator.set(e);
        }
    }
}

