/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.gui;

import java.util.ArrayList;
import java.util.List;
import mapwriter.config.Config;
import mapwriter.config.ConfigurationHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModGuiConfig
extends GuiConfig {
    public ModGuiConfig(GuiScreen guiScreen) {
        super(guiScreen, ModGuiConfig.getConfigElements(), "MapWriter", "Options", false, false, GuiConfig.getAbridgedConfigPath((String)ConfigurationHandler.configuration.toString()));
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add(ModGuiConfig.categoryElement("options", "Global Options", "mymod.configgui.ctgy.general"));
        list.add(Config.fullScreenMap.categoryElement("Fullscreen map options", "mymod.configgui.ctgy.foo"));
        list.add(Config.largeMap.categoryElement("Large map options", "mymod.configgui.ctgy.bar"));
        list.add(Config.smallMap.categoryElement("Small map options", "mymod.configgui.ctgy.bar"));
        return list;
    }

    private static IConfigElement categoryElement(String category, String name, String tooltip_key) {
        return new DummyConfigElement.DummyCategoryElement(name, tooltip_key, new ConfigElement(ConfigurationHandler.configuration.getCategory(category)).getChildElements());
    }

    public static class ModBooleanEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        public ModBooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.enabled = this.enabled();
            this.updateValueButtonText();
        }

        public void updateValueButtonText() {
            this.btnValue.displayString = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
        }

        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }

        public boolean enabled() {
            for (GuiConfigEntries.IConfigEntry entry : this.owningEntryList.listEntries) {
                if (!entry.getName().equals("circular") || !(entry instanceof GuiConfigEntries.BooleanEntry)) continue;
                return Boolean.valueOf(entry.getCurrentValue().toString());
            }
            return true;
        }
    }
}

