/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import cpw.mods.fml.common.FMLLog;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mapwriter.region.IChunk;
import mapwriter.region.RegionFile;
import mapwriter.region.RegionFileCache;
import mapwriter.region.RegionManager;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import org.apache.logging.log4j.Level;

public class MwChunk
implements IChunk {
    public static final int SIZE = 16;
    public final int x;
    public final int z;
    public final int dimension;
    public final byte[][] msbArray;
    public final byte[][] lsbArray;
    public final byte[][] metaArray;
    public final byte[][] lightingArray;
    public final Map tileentityMap;
    public final byte[] biomeArray;
    public final int maxY;
    private static Method CarpenterMethod = null;
    private static Method FMPMethodParts = null;
    private static Method FMPMethodMaterial = null;
    private static Field FMPFieldBlock = null;
    private static Field FMPFieldMeta = null;

    public MwChunk(int x, int z, int dimension, byte[][] msbArray, byte[][] lsbArray, byte[][] metaArray, byte[][] lightingArray, byte[] biomeArray, Map TileEntityMap) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
        this.msbArray = msbArray;
        this.lsbArray = lsbArray;
        this.metaArray = metaArray;
        this.biomeArray = biomeArray;
        this.lightingArray = lightingArray;
        this.tileentityMap = TileEntityMap;
        int maxY = 0;
        for (int y = 0; y < 16; ++y) {
            if (lsbArray[y] == null) continue;
            maxY = (y << 4) + 15;
        }
        this.maxY = maxY;
    }

    public String toString() {
        return String.format("(%d, %d) dim%d", this.x, this.z, this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MwChunk read(int x, int z, int dimension, RegionFileCache regionFileCache) {
        HashMap<ChunkPosition, TileEntity> TileEntityMap;
        byte[][] lightingArray;
        byte[][] metaArray;
        byte[][] lsbArray;
        byte[][] msbArray;
        byte[] biomeArray;
        block18: {
            biomeArray = null;
            msbArray = new byte[16][];
            lsbArray = new byte[16][];
            metaArray = new byte[16][];
            lightingArray = new byte[16][];
            TileEntityMap = new HashMap<ChunkPosition, TileEntity>();
            FilterInputStream dis = null;
            RegionFile regionFile = regionFileCache.getRegionFile(x << 4, z << 4, dimension);
            if (!regionFile.isOpen() && regionFile.exists()) {
                regionFile.open();
            }
            if (regionFile.isOpen()) {
                dis = regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F);
            }
            if (dis != null) {
                block17: {
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74794_a(dis);
                    NBTTagCompound level = nbttagcompound.func_74775_l("Level");
                    int xNbt = level.func_74762_e("xPos");
                    int zNbt = level.func_74762_e("zPos");
                    if (xNbt != x || zNbt != z) {
                        RegionManager.logWarning("chunk (%d, %d) has NBT coords (%d, %d)", x, z, xNbt, zNbt);
                    }
                    NBTTagList sections = level.func_150295_c("Sections", 10);
                    for (int k = 0; k < sections.func_74745_c(); ++k) {
                        NBTTagCompound section = sections.func_150305_b(k);
                        byte y = section.func_74771_c("Y");
                        lsbArray[y & 0xF] = section.func_74770_j("Blocks");
                        if (section.func_150297_b("Add", 7)) {
                            msbArray[y & 0xF] = section.func_74770_j("Add");
                        }
                        metaArray[y & 0xF] = section.func_74770_j("Data");
                    }
                    biomeArray = level.func_74770_j("Biomes");
                    NBTTagList nbttaglist2 = level.func_150295_c("TileEntities", 10);
                    if (nbttaglist2 == null) break block17;
                    for (int i1 = 0; i1 < nbttaglist2.func_74745_c(); ++i1) {
                        NBTTagCompound nbttagcompound4 = nbttaglist2.func_150305_b(i1);
                        TileEntity tileentity = TileEntity.func_145827_c((NBTTagCompound)nbttagcompound4);
                        if (tileentity == null) continue;
                        ChunkPosition chunkposition = new ChunkPosition(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e);
                        TileEntityMap.put(chunkposition, tileentity);
                    }
                }
                try {
                    dis.close();
                }
                catch (IOException e) {
                    RegionManager.logError("MwChunk.read: %s while closing input stream", e);
                }
                break block18;
                catch (IOException e) {
                    try {
                        RegionManager.logError("%s: could not read chunk (%d, %d) from region file\n", e, x, z);
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (IOException e2) {
                            RegionManager.logError("MwChunk.read: %s while closing input stream", e2);
                        }
                        throw throwable;
                    }
                    try {
                        dis.close();
                    }
                    catch (IOException e3) {
                        RegionManager.logError("MwChunk.read: %s while closing input stream", e3);
                    }
                }
            }
        }
        return new MwChunk(x, z, dimension, msbArray, lsbArray, metaArray, lightingArray, biomeArray, TileEntityMap);
    }

    public boolean isEmpty() {
        return this.maxY <= 0;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeArray != null ? this.biomeArray[(z & 0xF) << 4 | x & 0xF] & 0xFF : 0;
    }

    @Override
    public int getLightValue(int x, int y, int z) {
        return 15;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    public static void carpenterdata() {
        try {
            Class<?> act = Class.forName("com.carpentersblocks.tileentity.TEBase");
            CarpenterMethod = act.getMethod("getAttribute", Byte.TYPE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void FMPdata() {
        try {
            Class<?> act = Class.forName("codechicken.multipart.TileMultipart");
            FMPMethodParts = act.getMethod("jPartList", new Class[0]);
            act = Class.forName("codechicken.microblock.Microblock");
            FMPMethodMaterial = act.getMethod("getIMaterial", new Class[0]);
            act = Class.forName("codechicken.microblock.BlockMicroMaterial");
            FMPFieldBlock = act.getDeclaredField("block");
            FMPFieldBlock.setAccessible(true);
            FMPFieldMeta = act.getDeclaredField("meta");
            FMPFieldMeta.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    public int getBlockAndMetadata(int x, int y, int z) {
        int meta;
        int yi = y >> 4 & 0xF;
        int offset = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        ChunkPosition chunkposition = new ChunkPosition(x, y, z);
        int lsb = this.lsbArray != null && this.lsbArray[yi] != null && this.lsbArray[yi].length != 0 ? this.lsbArray[yi][offset] : 0;
        int msb = this.msbArray != null && this.msbArray[yi] != null && this.msbArray[yi].length != 0 ? this.msbArray[yi][offset >> 1] : 0;
        int n = meta = this.metaArray != null && this.metaArray[yi] != null && this.metaArray[yi].length != 0 ? this.metaArray[yi][offset >> 1] : 0;
        if (this.tileentityMap.containsKey(chunkposition)) {
            TileEntity value = (TileEntity)this.tileentityMap.get(chunkposition);
            int id = 0;
            if (CarpenterMethod != null) {
                try {
                    ItemStack itemStack = (ItemStack)CarpenterMethod.invoke((Object)value, (byte)6);
                    if (itemStack != null) {
                        ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
                        id = Block.func_149682_b((Block)itemBlock.field_150939_a);
                        meta = itemStack.func_77960_j();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (FMPMethodParts != null) {
                try {
                    for (Object temp : (List)FMPMethodParts.invoke((Object)value, new Object[0])) {
                        Object material = FMPMethodMaterial.invoke(temp, new Object[0]);
                        Block block = (Block)FMPFieldBlock.get(material);
                        id = Block.func_149682_b((Block)block);
                        meta = (Integer)FMPFieldMeta.get(material);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (id != 0) {
                lsb = id & 0xFF;
                msb = id > 255 ? (id & 0xF00) >> 8 : 0;
            }
        }
        return (offset & 1) == 1 ? (msb & 0xF0) << 8 | (lsb & 0xFF) << 4 | (meta & 0xF0) >> 4 : (msb & 0xF) << 12 | (lsb & 0xFF) << 4 | meta & 0xF;
    }

    private NBTTagCompound writeChunkToNBT() {
        NBTTagCompound nbttagcompound2;
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound.func_74782_a("Level", (NBTBase)nbttagcompound1);
        nbttagcompound1.func_74774_a("V", (byte)1);
        nbttagcompound1.func_74768_a("xPos", this.x);
        nbttagcompound1.func_74768_a("zPos", this.z);
        NBTTagList nbttaglist = new NBTTagList();
        int i = 16;
        for (int y = 0; y < i; ++y) {
            if (this.lsbArray == null || this.lsbArray[y] == null) continue;
            nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Y", (byte)y);
            nbttagcompound2.func_74773_a("Blocks", this.lsbArray[y]);
            if (this.msbArray != null && this.msbArray[y] != null) {
                nbttagcompound2.func_74773_a("Add", this.msbArray[y]);
            }
            nbttagcompound2.func_74773_a("Data", this.metaArray[y]);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound1.func_74782_a("Sections", (NBTBase)nbttaglist);
        nbttagcompound1.func_74773_a("Biomes", this.biomeArray);
        NBTTagList nbttaglist2 = new NBTTagList();
        NBTTagList nbttaglist3 = new NBTTagList();
        for (TileEntity tileentity : this.tileentityMap.values()) {
            nbttagcompound2 = new NBTTagCompound();
            try {
                tileentity.func_145841_b(nbttagcompound2);
                nbttaglist3.func_74742_a((NBTBase)nbttagcompound2);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"A TileEntity type %s has throw an exception trying to write state. It will not persist. Report this to the mod author", (Object[])new Object[]{tileentity.getClass().getName()});
            }
        }
        nbttagcompound1.func_74782_a("TileEntities", (NBTBase)nbttaglist3);
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean write(RegionFileCache regionFileCache) {
        boolean error;
        block11: {
            block12: {
                block13: {
                    error = false;
                    RegionFile regionFile = regionFileCache.getRegionFile(this.x << 4, this.z << 4, this.dimension);
                    if (!regionFile.isOpen()) {
                        error = regionFile.open();
                    }
                    if (error) break block12;
                    DataOutputStream dos = regionFile.getChunkDataOutputStream(this.x & 0x1F, this.z & 0x1F);
                    if (dos == null) break block13;
                    CompressedStreamTools.func_74800_a((NBTTagCompound)this.writeChunkToNBT(), (DataOutput)dos);
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        RegionManager.logError("%s while closing chunk data output stream", e);
                    }
                    break block11;
                    catch (IOException e) {
                        try {
                            RegionManager.logError("%s: could not write chunk (%d, %d) to region file", e, this.x, this.z);
                            error = true;
                        }
                        catch (Throwable throwable) {
                            try {
                                dos.close();
                            }
                            catch (IOException e2) {
                                RegionManager.logError("%s while closing chunk data output stream", e2);
                            }
                            throw throwable;
                        }
                        try {
                            dos.close();
                        }
                        catch (IOException e3) {
                            RegionManager.logError("%s while closing chunk data output stream", e3);
                        }
                        break block11;
                    }
                }
                RegionManager.logError("error: could not get output stream for chunk (%d, %d)", this.x, this.z);
                break block11;
            }
            RegionManager.logError("error: could not open region file for chunk (%d, %d)", this.x, this.z);
        }
        return error;
    }
}

