/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.util;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mapwriter.config.Config;
import mapwriter.util.Logging;
import mapwriter.util.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.chunk.Chunk;

public class Utils {
    public static int[] integerListToIntArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static String mungeString(String s) {
        s = s.replace('.', '_');
        s = s.replace('-', '_');
        s = s.replace(' ', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return Reference.patternInvalidChars.matcher(s).replaceAll("");
    }

    public static File getFreeFilename(File dir, String baseName, String ext) {
        int i;
        File outputFile = dir != null ? new File(dir, baseName + "." + ext) : new File(baseName + "." + ext);
        for (i = 0; outputFile.exists() && i < 1000; ++i) {
            outputFile = dir != null ? new File(dir, baseName + "." + i + "." + ext) : new File(baseName + "." + i + "." + ext);
        }
        return i < 1000 ? outputFile : null;
    }

    public static void printBoth(String msg) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null) {
            thePlayer.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
        Logging.log("%s", msg);
    }

    public static File getDimensionDir(File worldDir, int dimension) {
        File dimDir = dimension != 0 ? new File(worldDir, "DIM" + dimension) : worldDir;
        return dimDir;
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static int nextHighestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static String getCurrentDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        return dateFormat.format(new Date());
    }

    public static int distToChunkSq(int x, int z, Chunk chunk) {
        int dx = (chunk.field_76635_g << 4) + 8 - x;
        int dz = (chunk.field_76647_h << 4) + 8 - z;
        return dx * dx + dz * dz;
    }

    public static String getWorldName() {
        String worldName;
        if (Minecraft.func_71410_x().func_71387_A()) {
            IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
            worldName = server != null ? server.func_71270_I() : "sp_world";
        } else {
            worldName = Minecraft.func_71410_x().func_147104_D().field_78845_b;
            worldName = !Config.portNumberInWorldNameEnabled ? worldName.substring(0, worldName.indexOf(":")) : (worldName.indexOf(":") == -1 ? worldName + "_25565" : worldName.replace(":", "_"));
        }
        worldName = Utils.mungeString(worldName);
        if (worldName == "") {
            worldName = "default";
        }
        return worldName;
    }

    public static void openWebLink(URI p_175282_1_) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, p_175282_1_);
        }
        catch (Throwable throwable) {
            Logging.logError("Couldn't open link %s", throwable.getStackTrace().toString());
        }
    }

    public static <K, V> Map<K, V> checkedMapByCopy(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) throws ClassCastException {
        HashMap<K, V> m2 = new HashMap<K, V>(rawMap.size() * 4 / 3 + 1);
        for (Map.Entry e : rawMap.entrySet()) {
            try {
                m2.put(keyType.cast(e.getKey()), valueType.cast(e.getValue()));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                System.out.println("not assignable");
            }
        }
        return m2;
    }
}

