/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BeekeepingLogic
implements IBeekeepingLogic {
    private static final int MAX_POLLINATION_ATTEMPTS = 20;
    private static final int totalBreedingTime = 100;
    private static final int ticksPerCheckQueenCanWork = 10;
    private final IBeeHousing housing;
    private final boolean housingSupportsMultipleErrorStates;
    private int breedingTime;
    private int queenWorkCycleThrottle;
    private IEffectData[] effectData = new IEffectData[2];
    private ItemStack queenStack;
    private IBee queen;
    private IIndividual pollen;
    private int attemptedPollinations = 0;
    private final Stack<ItemStack> spawn = new Stack();
    private boolean hasFlowersCached = false;
    private int hasFlowersCooldown = 0;
    private Set<IErrorState> queenCanWorkCached = Collections.emptySet();
    private int queenCanWorkCooldown = 0;

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
        Set<IErrorState> errorStateSet = null;
        try {
            errorStateSet = housing.getErrorStates();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.housingSupportsMultipleErrorStates = errorStateSet != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.breedingTime = nbttagcompound.func_74762_e("BreedingTime");
        this.queenWorkCycleThrottle = nbttagcompound.func_74762_e("Throttle");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Offspring", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            this.spawn.add(ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("BreedingTime", this.breedingTime);
        nbttagcompound.func_74768_a("Throttle", this.queenWorkCycleThrottle);
        Stack<ItemStack> spawnCopy = new Stack<ItemStack>();
        spawnCopy.addAll(this.spawn);
        NBTTagList nbttaglist = new NBTTagList();
        while (!spawnCopy.isEmpty()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemStack)spawnCopy.pop()).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Offspring", (NBTBase)nbttaglist);
    }

    @Override
    public int getBreedingTime() {
        return this.breedingTime;
    }

    @Override
    public int getTotalBreedingTime() {
        return 100;
    }

    @Override
    public IBee getQueen() {
        return this.queen;
    }

    @Override
    public IBeeHousing getHousing() {
        return this.housing;
    }

    @Override
    public IEffectData[] getEffectData() {
        return this.effectData;
    }

    @Override
    public boolean canWork() {
        if (this.housingSupportsMultipleErrorStates) {
            Set<IErrorState> errorStates = this.housing.getErrorStates();
            for (IErrorState errorState : errorStates) {
                this.housing.setErrorCondition(false, errorState);
            }
        }
        boolean hasSpace = this.addPendingProducts();
        if (this.hasBreedablePrincess()) {
            return hasSpace;
        }
        if (this.hasHealthyQueen()) {
            boolean canWork = this.queenCanWork();
            boolean hasFlowers = this.hasFlowers();
            return hasSpace && canWork && hasFlowers;
        }
        return false;
    }

    @Override
    public void doWork() {
        if (this.hasBreedablePrincess()) {
            this.tickBreed();
        } else if (this.queen != null) {
            this.queenWorkTick();
        }
    }

    @Override
    public void update() {
        if (this.canWork()) {
            this.doWork();
        }
    }

    private boolean hasFlowers() {
        if (this.queen == null) {
            return true;
        }
        if (this.hasFlowersCooldown <= 0) {
            this.hasFlowersCached = this.queen.hasFlower(this.housing);
            this.hasFlowersCooldown = PluginApiculture.ticksPerBeeWorkCycle;
            if (!this.hasFlowersCached) {
                this.hasFlowersCooldown /= 2;
            }
        } else {
            --this.hasFlowersCooldown;
        }
        if (this.housingSupportsMultipleErrorStates) {
            this.housing.setErrorCondition(!this.hasFlowersCached, EnumErrorCode.NOFLOWER);
        } else if (this.hasFlowersCached) {
            this.housing.setErrorState(EnumErrorCode.OK);
        } else {
            this.housing.setErrorState(EnumErrorCode.NOFLOWER);
        }
        return this.hasFlowersCached;
    }

    private void queenWorkTick() {
        if (this.queen == null) {
            return;
        }
        this.effectData = this.queen.doEffect(this.effectData, this.housing);
        ++this.queenWorkCycleThrottle;
        if (this.queenWorkCycleThrottle >= PluginApiculture.ticksPerBeeWorkCycle) {
            this.queenWorkCycleThrottle = 0;
            this.doProduction();
            this.queen.plantFlowerRandom(this.housing);
            this.doPollination();
            this.queen.age(this.housing.getWorld(), this.housing.getLifespanModifier(this.queen.getGenome(), this.queen.getMate(), 0.0f));
            this.updateQueenItemNBT();
        }
    }

    private void doProduction() {
        if (this.queen == null) {
            return;
        }
        ItemStack[] products = this.queen.produceStacks(this.housing);
        if (products == null) {
            return;
        }
        this.housing.wearOutEquipment(1);
        for (ItemStack stack : products) {
            this.housing.addProduct(stack, false);
        }
    }

    private void doPollination() {
        if (this.queen == null) {
            return;
        }
        if (this.pollen == null) {
            this.pollen = this.queen.retrievePollen(this.housing);
            this.attemptedPollinations = 0;
            if (this.pollen != null && this.housing.onPollenRetrieved(this.queen, this.pollen, false)) {
                this.pollen = null;
            }
        }
        if (this.pollen != null) {
            ++this.attemptedPollinations;
            if (this.queen.pollinateRandom(this.housing, this.pollen) || this.attemptedPollinations >= 20) {
                this.pollen = null;
            }
        }
    }

    private void updateQueenItemNBT() {
        if (this.queen == null) {
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.queen.writeToNBT(nbttagcompound);
        this.housing.getQueen().func_77982_d(nbttagcompound);
    }

    private boolean addPendingProducts() {
        EnumErrorCode housingErrorState = null;
        while (!this.spawn.isEmpty()) {
            ItemStack next = this.spawn.peek();
            if (this.housing.addProduct(next, true)) {
                this.spawn.pop();
                housingErrorState = EnumErrorCode.OK;
                continue;
            }
            housingErrorState = EnumErrorCode.NOSPACE;
            break;
        }
        if (housingErrorState != null) {
            if (this.housingSupportsMultipleErrorStates) {
                boolean hasSpace = housingErrorState == EnumErrorCode.OK;
                this.housing.setErrorCondition(!hasSpace, EnumErrorCode.NOSPACE);
            } else {
                this.housing.setErrorState(housingErrorState);
            }
        }
        return housingErrorState != EnumErrorCode.NOSPACE;
    }

    private static boolean isQueenAlive(ItemStack queenStack) {
        NBTTagCompound nbtTagCompound = queenStack.func_77978_p();
        int health = nbtTagCompound.func_74762_e("Health");
        return health > 0;
    }

    private boolean hasHealthyQueen() {
        boolean hasQueen = true;
        EnumErrorCode housingErrorState = null;
        ItemStack queenStack = this.housing.getQueen();
        if (!ItemStack.func_77989_b((ItemStack)this.queenStack, (ItemStack)queenStack)) {
            this.queen = BeeManager.beeRoot.getMember(queenStack);
            this.queenStack = queenStack;
        }
        if (queenStack == null || !ForestryItem.beeQueenGE.isItemEqual(queenStack)) {
            housingErrorState = EnumErrorCode.NOQUEEN;
            hasQueen = false;
            this.queen = null;
        } else if (!BeekeepingLogic.isQueenAlive(queenStack)) {
            if (this.queen == null) {
                this.queen = BeeManager.beeRoot.getMember(queenStack);
            }
            this.killQueen();
            housingErrorState = EnumErrorCode.OK;
            hasQueen = false;
            this.queen = null;
        }
        if (this.housingSupportsMultipleErrorStates) {
            this.housing.setErrorCondition(!hasQueen, EnumErrorCode.NOQUEEN);
        } else if (housingErrorState != null) {
            this.housing.setErrorState(housingErrorState);
        }
        if (hasQueen && this.queen == null) {
            this.queen = BeeManager.beeRoot.getMember(queenStack);
        }
        return hasQueen;
    }

    private boolean hasBreedablePrincess() {
        boolean isBreedingPrincess = false;
        if (ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            boolean hasDrone = ForestryItem.beeDroneGE.isItemEqual(this.housing.getDrone());
            if (this.housingSupportsMultipleErrorStates) {
                this.housing.setErrorCondition(!hasDrone, EnumErrorCode.NODRONE);
            } else if (hasDrone) {
                this.housing.setErrorState(EnumErrorCode.OK);
            } else {
                this.housing.setErrorState(EnumErrorCode.NODRONE);
            }
            isBreedingPrincess = true;
        }
        return isBreedingPrincess;
    }

    private boolean queenCanWork() {
        if (this.queenCanWorkCooldown > 0) {
            --this.queenCanWorkCooldown;
        } else {
            if (this.queen == null) {
                return false;
            }
            this.queenCanWorkCached = this.checkQueenCanWork();
            this.queenCanWorkCooldown = 10;
        }
        Set<IErrorState> errorStates = this.queenCanWorkCached;
        if (errorStates.size() > 0) {
            if (this.housingSupportsMultipleErrorStates) {
                for (IErrorState errorState : errorStates) {
                    this.housing.setErrorCondition(true, errorState);
                }
            } else {
                IErrorState state = errorStates.iterator().next();
                this.housing.setErrorState(state);
            }
            return false;
        }
        return true;
    }

    private Set<IErrorState> checkQueenCanWork() {
        try {
            return this.queen.getCanWork(this.housing);
        }
        catch (Throwable ignored) {
            IErrorState state = this.queen.canWork(this.housing);
            if (state != EnumErrorCode.OK) {
                return Collections.singleton(state);
            }
            return Collections.emptySet();
        }
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < 100) {
            ++this.breedingTime;
        }
        if (this.breedingTime < 100) {
            return;
        }
        if (!ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(this.housing.getQueen());
        IBee drone = BeeManager.beeRoot.getMember(this.housing.getDrone());
        princess.mate(drone);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        princess.writeToNBT(nbttagcompound);
        ItemStack queen = ForestryItem.beeQueenGE.getItemStack();
        queen.func_77982_d(nbttagcompound);
        this.housing.setQueen(queen);
        this.housing.onQueenChange(this.housing.getQueen());
        BeeManager.beeRoot.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName()).registerQueen(princess);
        --this.housing.getDrone().field_77994_a;
        if (this.housing.getDrone().field_77994_a <= 0) {
            this.housing.setDrone(null);
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.housing.getDrone() == null || this.housing.getQueen() == null) {
            return false;
        }
        if (!ForestryItem.beeDroneGE.isItemEqual(this.housing.getDrone()) || !ForestryItem.beePrincessGE.isItemEqual(this.housing.getQueen())) {
            return false;
        }
        return this.housing.canBreed();
    }

    private void killQueen() {
        if (this.queen == null) {
            return;
        }
        if (this.queen.canSpawn()) {
            this.spawnOffspring(this.queen);
            this.housing.getQueen().field_77994_a = 0;
            this.housing.setQueen(null);
        } else {
            Proxies.log.warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            ItemStack convert = ForestryItem.beePrincessGE.getItemStack();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.queen.writeToNBT(nbttagcompound);
            convert.func_77982_d(nbttagcompound);
            this.spawn.add(convert);
            this.housing.setQueen(null);
        }
        this.housing.onQueenChange(this.housing.getQueen());
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        int count;
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(this.housing.getWorld(), this.housing.getOwnerName());
        this.housing.onQueenDeath(this.getQueen());
        boolean secondPrincess = (float)this.housing.getWorld().field_73012_v.nextInt(10000) < PluginApiculture.getSecondPrincessChance() * 100.0f;
        int n = count = secondPrincess ? 2 : 1;
        while (count > 0) {
            --count;
            IBee heiress = queen.spawnPrincess(this.housing);
            if (heiress == null) continue;
            ItemStack princess = BeeManager.beeRoot.getMemberStack(heiress, EnumBeeType.PRINCESS.ordinal());
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        for (IBee larva : larvae = queen.spawnDrones(this.housing)) {
            ItemStack drone = BeeManager.beeRoot.getMemberStack(larva, EnumBeeType.DRONE.ordinal());
            breedingTracker.registerDrone(larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (this.housing.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
        this.housing.onPostQueenDeath(this.getQueen());
    }
}

