/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeListener;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.ICrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class TileAlvearySieve
extends TileAlveary
implements ICrafter,
IBeeListener {
    public static final int BLOCK_META = 7;
    public static final int SLOT_POLLEN_1 = 0;
    public static final int SLOTS_POLLEN_COUNT = 4;
    public static final int SLOT_SIEVE = 4;

    public TileAlvearySieve() {
        super(7);
        this.setInternalInventory(new AlvearySieveInventoryAdapter(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySieveGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!(this.hasMaster() && this.isIntegratedIntoStructure() && Proxies.common.isSimulating(this.field_145850_b))) {
            return;
        }
        ((IAlvearyComponent)this.getCentralTE()).registerBeeListener(this);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(200)) {
            return;
        }
        if (!this.hasMaster() || !this.isIntegratedIntoStructure()) {
            return;
        }
        ((IAlvearyComponent)this.getCentralTE()).registerBeeListener(this);
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (side == 0 || side == 1) {
            return 2;
        }
        return 13;
    }

    private void destroySieve() {
        IInventoryAdapter inventory = this.getInternalInventory();
        inventory.func_70299_a(4, null);
    }

    private void destroyPollen() {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 4; ++i) {
            inventory.func_70299_a(i, null);
        }
    }

    private boolean canStorePollen() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(4) == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    private void storePollenStack(ItemStack itemstack) {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 4; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            inventory.func_70299_a(i, itemstack);
            return;
        }
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (slotIndex == 4) {
            this.destroyPollen();
            return inventory.func_70301_a(4);
        }
        this.destroySieve();
        return inventory.func_70301_a(slotIndex);
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    @Override
    public void onQueenChange(ItemStack queen) {
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public void onQueenDeath(IBee queen) {
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        if (isHandled) {
            return true;
        }
        if (!this.canStorePollen()) {
            return false;
        }
        this.storePollenStack(AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass()).getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal()));
        return true;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        return false;
    }

    private static class AlvearySieveInventoryAdapter
    extends TileInventoryAdapter<TileAlvearySieve> {
        public AlvearySieveInventoryAdapter(TileAlvearySieve alvearySieve) {
            super(alvearySieve, 5, "Items", 1);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return StackUtils.isIdenticalItem(ForestryItem.craftingMaterial.getItemStack(1, 3), itemStack);
        }
    }
}

