/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeGenome;
import forestry.arboriculture.genetics.FakePollinatable;
import forestry.arboriculture.genetics.ICheckPollinatable;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.StringUtil;
import forestry.core.vect.MutableVect;
import forestry.core.vect.Vect;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Bee
extends IndividualLiving
implements IBee {
    protected int generation;
    protected boolean isNatural = true;
    public IBeeGenome genome;
    public IBeeGenome mate;

    public Bee(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Bee(IBeeGenome genome, IBee mate) {
        this(genome);
        this.mate = mate.getGenome();
    }

    public Bee(IBeeGenome genome) {
        this(genome, true, 0);
    }

    public Bee(IBeeGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan());
        this.genome = genome;
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.genome = BeeDefinition.FOREST.getGenome();
            return;
        }
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("NA")) {
            this.isNatural = nbttagcompound.func_74767_n("NA");
        }
        if (nbttagcompound.func_74764_b("GEN")) {
            this.generation = nbttagcompound.func_74762_e("GEN");
        }
        this.genome = nbttagcompound.func_74764_b("Genome") ? new BeeGenome(nbttagcompound.func_74775_l("Genome")) : BeeDefinition.FOREST.getGenome();
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new BeeGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (!this.isNatural) {
            nbttagcompound.func_74757_a("NA", false);
        }
        if (this.generation > 0) {
            nbttagcompound.func_74768_a("GEN", this.generation);
        }
    }

    @Override
    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    @Override
    public boolean isNatural() {
        return this.isNatural;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IBee)) {
            return;
        }
        IBee drone = (IBee)individual;
        this.mate = drone.getGenome();
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBeeGenome getMate() {
        return this.mate;
    }

    @Override
    public IBee copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Bee(nbttagcompound);
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public Set<IErrorState> getCanWork(IBeeHousing housing) {
        World world = housing.getWorld();
        BiomeGenBase biome = housing.getBiome();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        if (world.func_72896_J() && !this.genome.getTolerantFlyer() && BiomeHelper.canRainOrSnow(biome) && !housing.isSealed()) {
            errorStates.add(EnumErrorCode.ISRAINING);
        }
        if (world.func_72935_r()) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOTNIGHT);
            }
        } else if (!this.canWorkAtNight() && !housing.isSelfLighted()) {
            errorStates.add(EnumErrorCode.NOTDAY);
        }
        if (world.func_72957_l(housing.getXCoord(), housing.getYCoord() + 2, housing.getZCoord()) > 11) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOTGLOOMY);
            }
        } else if (!this.canWorkAtNight() && !housing.isSelfLighted()) {
            errorStates.add(EnumErrorCode.NOTLUCID);
        }
        if (!(biome == null || BiomeHelper.isBiomeHellish(biome) || world.func_72937_j(housing.getXCoord(), housing.getYCoord() + 3, housing.getZCoord()) || this.genome.getCaveDwelling() || housing.isSunlightSimulated())) {
            errorStates.add(EnumErrorCode.NOSKY);
        }
        if (!this.isSuitableClimate(housing.getTemperature(), housing.getHumidity())) {
            errorStates.add(EnumErrorCode.INVALIDBIOME);
        }
        return errorStates;
    }

    @Override
    public IErrorState canWork(IBeeHousing housing) {
        Set<IErrorState> errorStates = this.getCanWork(housing);
        if (errorStates.size() == 0) {
            return EnumErrorCode.OK;
        }
        return errorStates.iterator().next();
    }

    private boolean canWorkAtNight() {
        return this.genome.getPrimary().isNocturnal() || this.genome.getNocturnal();
    }

    private boolean canWorkDuringDay() {
        return !this.genome.getPrimary().isNocturnal() || this.genome.getNocturnal();
    }

    public boolean isSuitableBiome(BiomeGenBase biome) {
        if (biome == null) {
            return false;
        }
        EnumTemperature temperature = EnumTemperature.getFromBiome(biome);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.field_76751_G);
        return this.isSuitableClimate(temperature, humidity);
    }

    private boolean isSuitableClimate(EnumTemperature temperature, EnumHumidity humidity) {
        return AlleleManager.climateHelper.isWithinLimits(temperature, humidity, this.genome.getPrimary().getTemperature(), this.genome.getToleranceTemp(), this.genome.getPrimary().getHumidity(), this.genome.getToleranceHumid());
    }

    @Override
    public boolean hasFlower(IBeeHousing housing) {
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect housingPos = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        Vect area = Bee.getArea(this.genome, housing);
        Vect offset = new Vect(-area.x / 2, -area.y / 2, -area.z / 2);
        boolean hasFlower = false;
        MutableVect posCurrent = new MutableVect(0, 0, 0);
        while (posCurrent.advancePositionInArea(area)) {
            Vect posBlock = Vect.add(housingPos, posCurrent, offset);
            if (!provider.isAcceptedFlower(housing.getWorld(), this, posBlock.x, posBlock.y, posBlock.z)) continue;
            hasFlower = true;
            break;
        }
        return hasFlower;
    }

    @Override
    public ArrayList<BiomeGenBase> getSuitableBiomes() {
        ArrayList<BiomeGenBase> suitableBiomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (!this.isSuitableBiome(biome)) continue;
            suitableBiomes.add(biome);
        }
        return suitableBiomes;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumBeeChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + StringUtil.localize("bees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        if (this.generation > 0) {
            EnumRarity rarity = this.generation >= 1000 ? EnumRarity.epic : (this.generation >= 100 ? EnumRarity.rare : (this.generation >= 10 ? EnumRarity.uncommon : EnumRarity.common));
            String generationString = rarity.field_77937_e + StringUtil.localizeAndFormat("gui.beealyzer.generations", this.generation);
            list.add(generationString);
        }
        IAllele speedAllele = this.genome.getActiveAllele(EnumBeeChromosome.SPEED);
        IAlleleTolerance tempToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance humidToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        String unlocalizedCustomSpeed = "tooltip.worker." + speedAllele.getUnlocalizedName().replaceAll("(.*)\\.", "");
        String speed = StringUtil.canTranslate(unlocalizedCustomSpeed) ? StringUtil.localize(unlocalizedCustomSpeed) : speedAllele.getName() + ' ' + StringUtil.localize("gui.worker");
        String lifespan = this.genome.getActiveAllele(EnumBeeChromosome.LIFESPAN).getName() + ' ' + StringUtil.localize("gui.life");
        String tempTolerance = EnumChatFormatting.GREEN + "T: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + tempToleranceAllele.getName();
        String humidTolerance = EnumChatFormatting.GREEN + "H: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + humidToleranceAllele.getName();
        String flowers = this.genome.getFlowerProvider().getDescription();
        list.add(lifespan);
        list.add(speed);
        list.add(tempTolerance);
        list.add(humidTolerance);
        list.add(flowers);
        if (this.genome.getNocturnal()) {
            list.add(EnumChatFormatting.RED + GenericRatings.rateActivityTime(this.genome.getNocturnal(), false));
        }
        if (this.genome.getTolerantFlyer()) {
            list.add(EnumChatFormatting.WHITE + StringUtil.localize("gui.flyer.tooltip"));
        }
    }

    @Override
    public void age(World world, float housingLifespanModifier) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        float finalModifier = housingLifespanModifier * mode.getLifespanModifier(this.genome, this.mate, housingLifespanModifier);
        super.age(world, finalModifier);
    }

    @Override
    public ItemStack[] getProduceList() {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        products.addAll(primary.getProducts().keySet());
        Set<ItemStack> secondaryProducts = secondary.getProducts().keySet();
        for (ItemStack second : secondaryProducts) {
            boolean skip = false;
            for (ItemStack compare : products) {
                if (!second.func_77969_a(compare)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new ItemStack[products.size()]);
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        Set<ItemStack> specialties = this.genome.getPrimary().getSpecialty().keySet();
        return specialties.toArray(new ItemStack[specialties.size()]);
    }

    @Override
    public ItemStack[] produceStacks(IBeeHousing housing) {
        if (housing == null) {
            Proxies.log.warning("Failed to produce in an apiary because the beehousing was null.");
            return null;
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(housing.getWorld());
        if (mode == null) {
            Proxies.log.warning("Failed to produce in an apiary because the beekeeping mode was null.");
            return null;
        }
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (mode.isOverworked(this, housing)) {
            this.setIsNatural(false);
        }
        float speed = this.genome.getSpeed() * housing.getProductionModifier(this.genome, 1.0f) * mode.getProductionModifier(this.genome, 1.0f);
        for (Map.Entry<ItemStack, Integer> entry : primary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)entry.getValue().intValue() * speed)) continue;
            products.add(entry.getKey().func_77946_l());
        }
        for (Map.Entry<ItemStack, Integer> entry : secondary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)Math.round(entry.getValue() / 2) * speed)) continue;
            products.add(entry.getKey().func_77946_l());
        }
        if (primary.isJubilant(this.genome, housing) && secondary.isJubilant(this.genome, housing)) {
            for (Map.Entry<ItemStack, Integer> entry : primary.getSpecialty().entrySet()) {
                if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)entry.getValue().intValue() * speed)) continue;
                products.add(entry.getKey().func_77946_l());
            }
        }
        ItemStack[] productsArray = products.toArray(new ItemStack[products.size()]);
        return this.genome.getFlowerProvider().affectProducts(housing.getWorld(), this, housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), productsArray);
    }

    @Override
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (BeeManager.beeRoot.getBeekeepingMode(housing.getWorld()).isFatigued(this, housing)) {
            return null;
        }
        return this.createOffspring(housing, this.getGeneration() + 1);
    }

    @Override
    public IBee[] spawnDrones(IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        int toCreate = BeeManager.beeRoot.getBeekeepingMode(world).getFinalFertility(this, world, housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, 0);
            if (offspring == null) continue;
            offspring.setIsNatural(true);
            bees.add(offspring);
        }
        if (bees.size() > 0) {
            return bees.toArray(new IBee[bees.size()]);
        }
        return null;
    }

    private IBee createOffspring(IBeeHousing housing, int generation) {
        IChromosome[] mutated2;
        World world = housing.getWorld();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Bee.mutateSpecies(housing, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Bee.mutateSpecies(housing, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        return new Bee(new BeeGenome(chromosomes), mode.isNaturalOffspring(this), generation);
    }

    private static IChromosome[] mutateSpecies(IBeeHousing housing, IBeeGenome genomeOne, IBeeGenome genomeTwo) {
        IBeeGenome genome1;
        IBeeGenome genome0;
        IAllele allele1;
        IAllele allele0;
        World world = housing.getWorld();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (IBeeMutation mutation : BeeManager.beeRoot.getMutations(true)) {
            float chance = mutation.getChance(housing, allele0, allele1, (IGenome)genome0, (IGenome)genome1);
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(world, housing.getOwnerName());
            breedingTracker.registerMutation(mutation);
            return BeeManager.beeRoot.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public IIndividual retrievePollen(IBeeHousing housing) {
        int chance = Math.round((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return null;
        }
        Vect area = Bee.getArea(this.genome, housing);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        IIndividual pollen = null;
        for (int i = 0; i < 20; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect blockPos = Vect.add(housingPos, randomPos, offset);
            TileEntity tile = world.func_147438_o(blockPos.x, blockPos.y, blockPos.z);
            if (tile instanceof IPollinatable) {
                IPollinatable pitcher = (IPollinatable)tile;
                if (this.genome.getFlowerProvider().isAcceptedPollinatable(world, pitcher)) {
                    pollen = pitcher.getPollen();
                }
            } else {
                pollen = GeneticsUtil.getErsatzPollen(world, blockPos.x, blockPos.y, blockPos.z);
            }
            if (pollen == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IIndividual pollen) {
        int chance = (int)((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return false;
        }
        Vect area = Bee.getArea(this.genome, housing);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        for (int i = 0; i < 30; ++i) {
            IPollinatable realPollinatable;
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect posBlock = Vect.add(housingPos, randomPos, offset);
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(world, posBlock.x, posBlock.y, posBlock.z);
            if (checkPollinatable == null || !this.genome.getFlowerProvider().isAcceptedPollinatable(world, new FakePollinatable(checkPollinatable)) || !checkPollinatable.canMateWith(pollen) || (realPollinatable = GeneticsUtil.getOrCreatePollinatable(housing.getOwnerName(), world, posBlock.x, posBlock.y, posBlock.z)) == null) continue;
            realPollinatable.mateWith(pollen);
            return true;
        }
        return false;
    }

    @Override
    public void plantFlowerRandom(IBeeHousing housing) {
        int chance = Math.round((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorld();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect area = Bee.getArea(this.genome, housing);
        Vect offset = new Vect(-area.x / 2, -area.y / 4, -area.z / 2);
        Vect housingPos = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(random, area);
            Vect posBlock = Vect.add(housingPos, randomPos, offset);
            if (provider.growFlower(world, this, posBlock.x, posBlock.y, posBlock.z)) break;
        }
    }

    private static Vect getArea(IBeeGenome genome, IBeeHousing housing) {
        int[] genomeTerritory = genome.getTerritory();
        float housingModifier = housing.getTerritoryModifier(genome, 1.0f);
        return new Vect(genomeTerritory).multiply(housingModifier * 3.0f);
    }
}

