/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.worldgen.Hive;
import forestry.core.config.Config;
import forestry.plugins.PluginApiculture;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class HiveDecorator {
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"FORESTRY_HIVES", (Class[])new Class[0], (Object[])new Object[0]);
    private static HiveDecorator instance;

    public static HiveDecorator instance() {
        if (instance == null) {
            instance = new HiveDecorator();
        }
        return instance;
    }

    private HiveDecorator() {
    }

    public void decorateHives(IChunkProvider chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (!TerrainGen.populate((IChunkProvider)chunkProvider, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        this.decorateHives(world, rand, chunkX, chunkZ);
    }

    public void decorateHives(World world, Random rand, int chunkX, int chunkZ) {
        List<Hive> hives = PluginApiculture.hiveRegistry.getHives();
        if (Config.generateBeehivesDebug) {
            this.decorateHivesDebug(world, chunkX, chunkZ, hives);
            return;
        }
        Collections.shuffle(hives, rand);
        for (Hive hive : hives) {
            if (!this.genHive(world, rand, chunkX, chunkZ, hive)) continue;
            return;
        }
    }

    public boolean genHive(World world, Random rand, int chunkX, int chunkZ, Hive hive) {
        if (hive.genChance() * Config.getBeehivesRate() < rand.nextFloat() * 100.0f) {
            return false;
        }
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        BiomeGenBase biome = world.func_72807_a(worldX, worldZ);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.field_76751_G);
        if (!hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity)) {
            return false;
        }
        for (int tries = 0; tries < 4; ++tries) {
            int z;
            int x = worldX + rand.nextInt(16);
            if (!this.tryGenHive(world, x, z = worldZ + rand.nextInt(16), hive)) continue;
            return true;
        }
        return false;
    }

    private void decorateHivesDebug(World world, int chunkX, int chunkZ, List<Hive> hives) {
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        BiomeGenBase biome = world.func_72807_a(worldX, worldZ);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.field_76751_G);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Collections.shuffle(hives, world.field_73012_v);
                for (Hive hive : hives) {
                    if (!hive.isGoodBiome(biome) || !hive.isGoodHumidity(humidity)) continue;
                    this.tryGenHive(world, worldX + x, worldZ + z, hive);
                }
            }
        }
    }

    private boolean tryGenHive(World world, int x, int z, Hive hive) {
        int y = hive.getYForHive(world, x, z);
        if (y < 0) {
            return false;
        }
        if (!hive.canReplace(world, x, y, z)) {
            return false;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        EnumTemperature temperature = EnumTemperature.getFromValue(biome.func_150564_a(x, y, z));
        if (!hive.isGoodTemperature(temperature)) {
            return false;
        }
        if (!hive.isValidLocation(world, x, y, z)) {
            return false;
        }
        return this.setHive(world, x, y, z, hive);
    }

    protected boolean setHive(World world, int x, int y, int z, Hive hive) {
        Block hiveBlock = hive.getHiveBlock();
        boolean placed = world.func_147465_d(x, y, z, hiveBlock, hive.getHiveMeta(), 2);
        if (!placed) {
            return false;
        }
        Block placedBlock = world.func_147439_a(x, y, z);
        if (!Block.func_149680_a((Block)hiveBlock, (Block)placedBlock)) {
            return false;
        }
        hiveBlock.func_149726_b(world, x, y, z);
        world.func_147471_g(x, y, z);
        if (!Config.generateBeehivesDebug) {
            hive.postGen(world, x, y, z);
        }
        return true;
    }
}

