/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.core.config.ForestryBlock;
import forestry.core.items.ItemForestryBlock;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemStairs
extends ItemForestryBlock {
    public ItemStairs(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        WoodType type = WoodType.getFromCompound(stack.func_77978_p());
        return this.placeStairs(world, player, stack, type, x, y, z, metadata);
    }

    private boolean placeStairs(World world, EntityPlayer player, ItemStack stack, WoodType type, int x, int y, int z, int metadata) {
        boolean placed = ForestryBlock.stairs.setBlock(world, x, y, z, metadata, 2);
        if (!placed) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (!ForestryBlock.stairs.isBlockEqual(block)) {
            return false;
        }
        block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
        block.func_149714_e(world, x, y, z, metadata);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileStairs)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        ((TileStairs)tile).setWoodType(type);
        return true;
    }

    public String func_77653_i(ItemStack itemStack) {
        String displayName;
        WoodType woodType = WoodType.getFromCompound(itemStack.func_77978_p());
        if (woodType == null) {
            return null;
        }
        String customUnlocalizedName = "stairs." + woodType.ordinal() + ".name";
        if (StringUtil.canTranslateTile(customUnlocalizedName)) {
            displayName = StringUtil.localizeTile(customUnlocalizedName);
        } else {
            String woodGrammar = StringUtil.localize("stairs.grammar");
            String woodTypeName = StringUtil.localize("trees.woodType." + (Object)((Object)woodType));
            displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
        }
        return displayName;
    }
}

