/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network;

import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;

public class PacketRipeningUpdate
extends PacketCoordinates {
    private int value;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketRipeningUpdate(data);
    }

    public PacketRipeningUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketRipeningUpdate(TileFruitPod fruitPod) {
        super(PacketId.RIPENING_UPDATE, fruitPod);
        this.value = fruitPod.getMaturity();
    }

    public PacketRipeningUpdate(TileLeaves leaves) {
        super(PacketId.RIPENING_UPDATE, leaves);
        this.value = leaves.getFruitColour();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeVarInt(this.value);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.value = data.readVarInt();
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof TileLeaves) {
            ((TileLeaves)tile).fromRipeningPacket(this.value);
        } else if (tile instanceof TileFruitPod) {
            ((TileFruitPod)tile).fromRipeningPacket(this.value);
        }
    }

    public int getValue() {
        return this.value;
    }
}

