/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Objects;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class Genome
implements IGenome {
    private static final String SLOT_TAG = "Slot";
    private IChromosome[] chromosomes;

    public Genome(NBTTagCompound nbttagcompound) {
        this.chromosomes = new Chromosome[this.getDefaultTemplate().length];
        this.readFromNBT(nbttagcompound);
    }

    private IAllele[] getDefaultTemplate() {
        return this.getSpeciesRoot().getDefaultTemplate();
    }

    public Genome(IChromosome[] chromosomes) {
        if (chromosomes.length != this.getDefaultTemplate().length) {
            throw new IllegalArgumentException(String.format("Tried to create a genome for '%s' from an invalid chromosome template.", this.getSpeciesRoot().getUID()));
        }
        this.chromosomes = chromosomes;
    }

    protected static IAlleleSpecies getSpeciesDirectly(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        NBTTagCompound genomeNBT = nbtTagCompound.func_74775_l("Genome");
        if (genomeNBT == null) {
            return null;
        }
        NBTTagList chromosomesNBT = genomeNBT.func_150295_c("Chromosomes", 10);
        if (chromosomesNBT == null) {
            return null;
        }
        NBTTagCompound chromosomeNBT = chromosomesNBT.func_150305_b(0);
        Chromosome chromosome = Chromosome.loadChromosomeFromNBT(chromosomeNBT);
        IAllele activeAllele = chromosome.getActiveAllele();
        if (!(activeAllele instanceof IAlleleSpecies)) {
            return null;
        }
        return (IAlleleSpecies)activeAllele;
    }

    public static IChromosome getChromosome(ItemStack itemStack, IChromosomeType chromosomeType, ISpeciesRoot speciesRoot) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        NBTTagCompound genome = nbtTagCompound.func_74775_l("Genome");
        if (genome == null) {
            return null;
        }
        IChromosome[] chromosomes = Genome.getChromosomes(genome, speciesRoot);
        if (chromosomes == null) {
            return null;
        }
        return chromosomes[chromosomeType.ordinal()];
    }

    public static IChromosome[] getChromosomes(NBTTagCompound genomeNBT, ISpeciesRoot speciesRoot) {
        NBTTagList chromosomesNBT = genomeNBT.func_150295_c("Chromosomes", 10);
        IChromosome[] chromosomes = new IChromosome[speciesRoot.getDefaultTemplate().length];
        for (int i = 0; i < chromosomesNBT.func_74745_c(); ++i) {
            Class<? extends IAllele> chromosomeClass;
            IAllele template;
            NBTTagCompound chromosomeNBT = chromosomesNBT.func_150305_b(i);
            byte chromosomeOrdinal = chromosomeNBT.func_74771_c(SLOT_TAG);
            if (chromosomeOrdinal < 0 || chromosomeOrdinal >= chromosomes.length) continue;
            Chromosome chromosome = Chromosome.loadChromosomeFromNBT(chromosomeNBT);
            chromosomes[chromosomeOrdinal] = chromosome;
            if (Config.clearInvalidChromosomes && chromosome.overrideInvalidAlleles(template = speciesRoot.getDefaultTemplate()[chromosomeOrdinal], chromosomeClass = speciesRoot.getKaryotype()[chromosomeOrdinal].getAlleleClass())) {
                chromosome.writeToNBT(chromosomeNBT);
            }
            if (!chromosome.hasInvalidAlleles(speciesRoot.getKaryotype()[chromosomeOrdinal].getAlleleClass())) continue;
            throw new RuntimeException("Found Chromosome with invalid Alleles.\nNBTTagCompound: " + chromosomesNBT + "\nSee config option \"genetics.clear.invalid.chromosomes\".\nMissing: " + chromosomeNBT);
        }
        IChromosome speciesChromosome = chromosomes[EnumTreeChromosome.SPECIES.ordinal()];
        if (speciesChromosome != null) {
            IAlleleSpecies species = (IAlleleSpecies)speciesChromosome.getActiveAllele();
            IAllele[] template = speciesRoot.getTemplate(species.getUID());
            for (int i = 0; i < chromosomes.length; ++i) {
                IAllele allele = template[i];
                if (chromosomes[i] != null || allele == null) continue;
                chromosomes[i] = new Chromosome(allele);
            }
        }
        return chromosomes;
    }

    public static IAllele getActiveAllele(ItemStack itemStack, IChromosomeType chromosomeType, ISpeciesRoot speciesRoot) {
        IChromosome chromosome = Genome.getChromosome(itemStack, chromosomeType, speciesRoot);
        if (chromosome == null) {
            return null;
        }
        return chromosome.getActiveAllele();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.chromosomes = Genome.getChromosomes(nbttagcompound, this.getSpeciesRoot());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chromosomes.length; ++i) {
            if (this.chromosomes[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(SLOT_TAG, (byte)i);
            this.chromosomes[i].writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Chromosomes", (NBTBase)nbttaglist);
    }

    @Override
    public IChromosome[] getChromosomes() {
        return Arrays.copyOf(this.chromosomes, this.chromosomes.length);
    }

    @Override
    public IAllele getActiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getActiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.ordinal()].getInactiveAllele();
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] genetics = other.getChromosomes();
        if (this.chromosomes.length != genetics.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            IChromosome otherChromosome = genetics[i];
            if (chromosome == null && otherChromosome == null) continue;
            if (chromosome == null || otherChromosome == null) {
                return false;
            }
            if (!chromosome.getPrimaryAllele().getUID().equals(otherChromosome.getPrimaryAllele().getUID())) {
                return false;
            }
            if (chromosome.getSecondaryAllele().getUID().equals(otherChromosome.getSecondaryAllele().getUID())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        int i = 0;
        for (IChromosome chromosome : this.chromosomes) {
            toStringHelper.add(String.valueOf(i++), (Object)chromosome);
        }
        return toStringHelper.toString();
    }
}

