/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IClimatised;
import forestry.core.utils.StringUtil;

public class ClimateLedger
extends Ledger {
    private final IClimatised tile;

    public ClimateLedger(LedgerManager manager, IClimatised tile) {
        super(manager, "climate");
        this.tile = tile;
        this.maxHeight = 72;
    }

    @Override
    public void draw(int x, int y) {
        EnumTemperature temperature = this.tile.getTemperature();
        this.drawBackground(x, y);
        this.drawIcon(temperature.getIcon(), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.climate"), x + 22, y + 8);
        this.drawSubheader(StringUtil.localize("gui.temperature") + ':', x + 22, y + 20);
        this.drawText(AlleleManager.climateHelper.toDisplay(temperature) + ' ' + StringUtil.floatAsPercent(this.tile.getExactTemperature()), x + 22, y + 32);
        this.drawSubheader(StringUtil.localize("gui.humidity") + ':', x + 22, y + 44);
        this.drawText(AlleleManager.climateHelper.toDisplay(this.tile.getHumidity()) + ' ' + StringUtil.floatAsPercent(this.tile.getExactHumidity()), x + 22, y + 56);
    }

    @Override
    public String getTooltip() {
        return "T: " + AlleleManager.climateHelper.toDisplay(this.tile.getTemperature()) + " / H: " + AlleleManager.climateHelper.toDisplay(this.tile.getHumidity());
    }
}

