/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import forestry.core.config.Defaults;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.ITileFilter;
import forestry.core.inventory.ItemStackMap;
import forestry.core.inventory.filters.ArrayStackFilter;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.filters.InvertedStackFilter;
import forestry.core.inventory.filters.StackFilter;
import forestry.core.inventory.manipulators.InventoryManipulator;
import forestry.core.inventory.wrappers.ChestWrapper;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryCopy;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.inventory.wrappers.SidedInventoryMapper;
import forestry.core.utils.AdjacentTileCache;
import forestry.core.utils.PlainInventory;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InvTools {
    private static final String TAG_SLOT = "Slot";

    public static int getXOnSide(int x, ForgeDirection side) {
        return x + side.offsetX;
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        return y + side.offsetY;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        return z + side.offsetZ;
    }

    public static boolean blockExistsOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return world.func_72899_e(InvTools.getXOnSide(x, side), InvTools.getYOnSide(y, side), InvTools.getZOnSide(z, side));
    }

    public static int getBlockMetadataOnSide(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return world.func_72805_g(InvTools.getXOnSide(i, side), InvTools.getYOnSide(j, side), InvTools.getZOnSide(k, side));
    }

    public static Block getBlockOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_147439_a(InvTools.getXOnSide(x, side), InvTools.getYOnSide(y, side), InvTools.getZOnSide(z, side));
    }

    public static TileEntity getBlockTileEntityOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int sz;
        int sy;
        int sx = InvTools.getXOnSide(x, side);
        if (world.func_72899_e(sx, sy = InvTools.getYOnSide(y, side), sz = InvTools.getZOnSide(z, side))) {
            return world.func_147438_o(sx, sy, sz);
        }
        return null;
    }

    public static TileEntity getBlockTileEntityOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int sx = InvTools.getXOnSide(x, side);
        int sy = InvTools.getYOnSide(y, side);
        int sz = InvTools.getZOnSide(z, side);
        return world.func_147438_o(sx, sy, sz);
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventories(world, i, j, k, null);
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k, Class<? extends IInventory> type) {
        ArrayList<IInventory> list = new ArrayList<IInventory>(5);
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            list.add(inv);
        }
        return list;
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventoryMap(world, i, j, k, null);
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k, Class<? extends IInventory> type) {
        TreeMap<Integer, IInventory> map = new TreeMap<Integer, IInventory>();
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            map.put(side, inv);
        }
        return map;
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, final Class<? extends IInventory> type, final Class<? extends IInventory> exclude) {
        return InvTools.getInventoryFromSide(world, x, y, z, side, new ITileFilter(){

            @Override
            public boolean matches(TileEntity tile) {
                if (type != null && !type.isAssignableFrom(tile.getClass())) {
                    return false;
                }
                return exclude == null || !exclude.isAssignableFrom(tile.getClass());
            }
        });
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, ITileFilter filter) {
        TileEntity tile = InvTools.getBlockTileEntityOnSide(world, x, y, z, side);
        if (tile == null || !(tile instanceof IInventory) || !filter.matches(tile)) {
            return null;
        }
        return InvTools.getInventoryFromTile(tile, side.getOpposite());
    }

    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return new ChestWrapper(chest);
        }
        return InvTools.getInventory((IInventory)tile, side);
    }

    public static IInventory getInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMapper((ISidedInventory)inv, side);
        }
        return inv;
    }

    public static int[] buildSlotArray(int start, int size) {
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = start + i;
        }
        return slots;
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static ItemStack damageItem(ItemStack stack, int damage) {
        if (!stack.func_77984_f()) {
            return stack;
        }
        int curDamage = stack.func_77960_j();
        stack.func_77964_b(curDamage += damage);
        if (stack.func_77960_j() > stack.func_77958_k()) {
            --stack.field_77994_a;
            stack.func_77964_b(0);
        }
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack == null || stack.field_77994_a < 1) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, x, y + 1.5, z, stack);
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static boolean isInventoryEmpty(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryEmpty(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> i$ = InventoryIterator.getIterable(inv).iterator();
        while (i$.hasNext() && (stack = (slot = i$.next()).getStackInSlot()) == null) {
        }
        return stack == null;
    }

    public static boolean isInventoryFull(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryFull(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryFull(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> i$ = InventoryIterator.getIterable(inv).iterator();
        while (i$.hasNext() && (stack = (slot = i$.next()).getStackInSlot()) != null) {
        }
        return stack != null;
    }

    public static int countItems(IInventory inv) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static int countItems(IInventory inv, IStackFilter filter) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean numItemsMoreThan(IInventory inv, int amount) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null) {
                count += stack.field_77994_a;
            }
            if (count < amount) continue;
            return true;
        }
        return false;
    }

    public static int countItems(IInventory inv, ItemStack ... filters) {
        if (inv instanceof InventoryMapper) {
            inv = ((InventoryMapper)inv).getBaseInventory();
        }
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (!hasFilter) {
            return InvTools.countItems(inv);
        }
        int count = 0;
        block1: for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            for (ItemStack filter : filters) {
                if (filter == null || !InvTools.isItemEqual(stack, filter)) continue;
                count += stack.field_77994_a;
                continue block1;
            }
        }
        return count;
    }

    public static int countItems(Iterable<IInventory> inventories, ItemStack ... filter) {
        int count = 0;
        for (IInventory inv : inventories) {
            count += InvTools.countItems(inv, filter);
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ItemStack item) {
        return InvTools.countItems(inv, item) > 0;
    }

    public static Map<ItemStack, Integer> getManifest(IInventory inv) {
        ItemStackMap<Integer> manifest = new ItemStackMap<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            Integer count = (Integer)manifest.get(slot);
            if (count == null) {
                count = 0;
            }
            count = count + slot.field_77994_a;
            manifest.put(slot, count);
        }
        return manifest;
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new ArrayStackFilter(filters));
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, IStackFilter filter) {
        InventoryManipulator imSource = InventoryManipulator.get(source);
        return imSource.moveItem(dest, filter);
    }

    public static ItemStack moveOneItem(Iterable<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(Iterable<IInventory> sources, IInventory dest, IStackFilter filter) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filter);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, Iterable<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItem(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new InvertedStackFilter(new ArrayStackFilter(filters)));
    }

    public static ItemStack moveOneItemExcept(Iterable<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItemExcept(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, Iterable<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItemExcept(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InvTools.isWildcard(stack.func_77960_j());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.field_77994_a != b.field_77994_a) {
            return false;
        }
        if (a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isItemEqualSemiStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqualIgnoreNBT(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, false);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchNBT && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (InvTools.isWildcard(a) || InvTools.isWildcard(b)) {
                return true;
            }
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack stack, Collection<ItemStack> matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static boolean moveItemStack(IInventory source, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        for (IInvSlot slot : InventoryIterator.getIterable(source)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            ItemStack remainder = im.addStack(stack);
            slot.setStackInSlot(remainder);
            return !InvTools.isItemEqualStrict(stack, remainder);
        }
        return false;
    }

    public static boolean moveItemStack(IInventory source, Iterable<IInventory> destinations) {
        for (IInventory dest : destinations) {
            if (!InvTools.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoomForStack(ItemStack stack, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.canAddStack(stack);
    }

    public static ItemStack[] removeItems(IInventory inv, int numItems) {
        PlainInventory output = new PlainInventory(27, "temp");
        for (int i = 0; i < inv.func_70302_i_() && numItems > 0; ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            ItemStack removed = inv.func_70298_a(i, numItems);
            numItems -= removed.field_77994_a;
            ItemStack remainder = InvTools.moveItemStack(removed, (IInventory)output);
            if (remainder == null) continue;
            InvTools.moveItemStack(remainder, inv);
            numItems += remainder.field_77994_a;
            break;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (ItemStack stack : output.getContents()) {
            if (stack == null) continue;
            list.add(stack);
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InvTools.removeOneItem(inv, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InvTools.removeOneItem(inv, (IStackFilter)new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeItem(filter);
    }

    public static ItemStack removeOneItem(Iterable<IInventory> invs, IStackFilter filter) {
        for (IInventory inv : invs) {
            ItemStack stack = InvTools.removeOneItem(inv, filter);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache) {
        return InvTools.moveOneItemToPipe(source, tileCache, ForgeDirection.VALID_DIRECTIONS);
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        if (PluginManager.Module.BUILDCRAFT_TRANSPORT.isEnabled()) {
            return InvTools.internal_moveOneItemToPipe(source, tileCache, directions);
        }
        return false;
    }

    @Optional.Method(modid="BuildCraftAPI|transport")
    private static boolean internal_moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        InventoryCopy invClone = new InventoryCopy(source);
        ItemStack stackToMove = InvTools.removeOneItem(invClone);
        if (stackToMove == null) {
            return false;
        }
        if (stackToMove.field_77994_a <= 0) {
            return false;
        }
        ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>> pipes = new ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>>();
        boolean foundPipe = false;
        for (ForgeDirection side : directions) {
            IPipeTile pipe;
            TileEntity tile = tileCache.getTileOnSide(side);
            if (!(tile instanceof IPipeTile) || (pipe = (IPipeTile)tile).getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(side.getOpposite())) continue;
            pipes.add(new AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>(side, pipe));
            foundPipe = true;
        }
        if (!foundPipe) {
            return false;
        }
        int choice = tileCache.getSource().func_145831_w().field_73012_v.nextInt(pipes.size());
        Map.Entry pipe = (Map.Entry)pipes.get(choice);
        if (((IPipeTile)pipe.getValue()).injectItem(stackToMove, false, ((ForgeDirection)pipe.getKey()).getOpposite(), null) > 0 && InvTools.removeOneItem(source, stackToMove) != null) {
            ((IPipeTile)pipe.getValue()).injectItem(stackToMove, true, ((ForgeDirection)pipe.getKey()).getOpposite(), null);
            return true;
        }
        return false;
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a(TAG_SLOT, slot);
            InvTools.writeItemToNBT(stack, itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_150295_c(tag, 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.func_150305_b(entry);
            byte slot = itemTag.func_74771_c(TAG_SLOT);
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (stack.field_77994_a > 127) {
            stack.field_77994_a = 127;
        }
        stack.func_77955_b(data);
    }

    public static IInventoryAdapter configureSidedUp(IInventoryAdapter inventory, int startSlot, int count) {
        return InvTools.configureSided(inventory, 1, startSlot, count);
    }

    public static IInventoryAdapter configureSidedDown(IInventoryAdapter inventory, int startSlot, int count) {
        return InvTools.configureSided(inventory, 0, startSlot, count);
    }

    public static IInventoryAdapter configureSidedNorthSouth(IInventoryAdapter inventory, int startSlot, int count) {
        return InvTools.configureSided(inventory, Defaults.FACING_NORTHSOUTH, startSlot, count);
    }

    public static IInventoryAdapter configureSidedWestEast(IInventoryAdapter inventory, int startSlot, int count) {
        return InvTools.configureSided(inventory, Defaults.FACING_WESTEAST, startSlot, count);
    }

    public static IInventoryAdapter configureSidedSides(IInventoryAdapter inventory, int startSlot, int count) {
        return InvTools.configureSided(inventory, Defaults.FACING_SIDES, startSlot, count);
    }

    public static IInventoryAdapter configureSided(IInventoryAdapter inventory, int side, int startSlot, int count) {
        return InvTools.configureSided(inventory, new int[]{side}, startSlot, count);
    }

    public static IInventoryAdapter configureSided(IInventoryAdapter inventory, int[] sides, int startSlot, int count) {
        int[] slots = new int[count];
        for (int i = 0; i < count; ++i) {
            slots[i] = startSlot + i;
        }
        return inventory.configureSided(sides, slots);
    }

    public static boolean removeSets(IInventory inventory, int count, ItemStack[] set, EntityPlayer player, boolean stowContainer, boolean oreDictionary) {
        return InvTools.removeSets(inventory, count, set, 0, inventory.func_70302_i_(), player, stowContainer, oreDictionary, false) != null;
    }

    public static boolean removeSets(IInventory inventory, int count, ItemStack[] set, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary) {
        return InvTools.removeSets(inventory, count, set, firstSlotIndex, slotCount, player, stowContainer, oreDictionary, false) != null;
    }

    public static ItemStack[] removeSets(IInventory inventory, int count, ItemStack[] set, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        ItemStack[] removed = new ItemStack[set.length];
        ItemStack[] stock = InvTools.getStacks(inventory, firstSlotIndex, slotCount);
        if (StackUtils.containsSets(set, stock, oreDictionary, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.length; ++i) {
            if (set[i] == null) continue;
            ItemStack stackToRemove = set[i].func_77946_l();
            stackToRemove.field_77994_a *= count;
            ItemStack removedStack = InvTools.removeStack(inventory, stackToRemove, firstSlotIndex, slotCount, player, stowContainer, false, false);
            if (removedStack == null) {
                removedStack = InvTools.removeStack(inventory, stackToRemove, firstSlotIndex, slotCount, player, stowContainer, oreDictionary, craftingTools);
            }
            removed[i] = removedStack;
        }
        return removed;
    }

    private static ItemStack removeStack(IInventory inventory, ItemStack stackToRemove, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        for (int j = firstSlotIndex; j < firstSlotIndex + slotCount; ++j) {
            ItemStack stackInSlot = inventory.func_70301_a(j);
            if (stackInSlot == null || !StackUtils.isCraftingEquivalent(stackToRemove, stackInSlot, oreDictionary, craftingTools)) continue;
            ItemStack removed = inventory.func_70298_a(j, stackToRemove.field_77994_a);
            stackToRemove.field_77994_a -= removed.field_77994_a;
            if (stowContainer && stackToRemove.func_77973_b().hasContainerItem(stackToRemove)) {
                StackUtils.stowContainerItem(removed, inventory, j, player);
            }
            if (stackToRemove.field_77994_a != 0) continue;
            return removed;
        }
        return null;
    }

    public static boolean contains(IInventory inventory, ItemStack query, int startSlot, int slots) {
        ItemStack[] queryArray = new ItemStack[]{query};
        return InvTools.contains(inventory, queryArray, startSlot, slots);
    }

    public static boolean contains(IInventory inventory, ItemStack[] query, int startSlot, int slots) {
        ItemStack[] stock = InvTools.getStacks(inventory, startSlot, slots);
        return StackUtils.containsSets(query, stock) > 0;
    }

    public static boolean containsPercent(IInventory inventory, float percent, int slot1, int length) {
        int amount = 0;
        int stackMax = 0;
        for (ItemStack itemStack : InvTools.getStacks(inventory, slot1, length)) {
            if (itemStack == null) {
                stackMax += 64;
                continue;
            }
            amount += itemStack.field_77994_a;
            stackMax += itemStack.func_77976_d();
        }
        if (stackMax == 0) {
            return false;
        }
        return (float)amount / (float)stackMax >= percent;
    }

    public static boolean containsAmount(IInventory inventory, int amount, int slot1, int length) {
        int total = 0;
        for (ItemStack itemStack : InvTools.getStacks(inventory, slot1, length)) {
            if (itemStack == null || (total += itemStack.field_77994_a) < amount) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] getStacks(IInventory inventory) {
        ItemStack[] stacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks[i] = inventory.func_70301_a(i);
        }
        return stacks;
    }

    public static ItemStack[] getStacks(IInventory inventory, int slot1, int length) {
        ItemStack[] result = new ItemStack[length];
        for (int i = slot1; i < slot1 + length; ++i) {
            result[i - slot1] = inventory.func_70301_a(i);
        }
        return result;
    }

    public static boolean tryAddStacksCopy(IInventory inventory, ItemStack[] stacks, boolean all) {
        return InvTools.tryAddStacksCopy(inventory, stacks, 0, inventory.func_70302_i_(), all);
    }

    public static boolean tryAddStacksCopy(IInventory inventory, ItemStack[] stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || InvTools.tryAddStack(inventory, stack.func_77946_l(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStacks(IInventory inventory, ItemStack[] stacks, boolean all) {
        boolean addedAll = true;
        for (ItemStack stack : stacks) {
            if (stack == null || InvTools.tryAddStack(inventory, stack, all)) continue;
            addedAll = false;
        }
        return addedAll;
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all) {
        return InvTools.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InvTools.tryAddStack(inventory, stack, 0, inventory.func_70302_i_(), all, doAdd);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InvTools.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        boolean success;
        int added = InvTools.addStack(inventory, stack, startSlot, slots, false);
        boolean bl = all ? added == stack.field_77994_a : (success = added > 0);
        if (success && doAdd) {
            InvTools.addStack(inventory, stack, startSlot, slots, true);
        }
        return success;
    }

    public static int addStack(IInventory inventory, ItemStack stack, boolean doAdd) {
        return InvTools.addStack(inventory, stack, 0, inventory.func_70302_i_(), doAdd);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null || inventoryStack.func_77973_b() == null || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.field_77994_a - added;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.field_77994_a += remain;
                }
                return stack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        if (added >= stack.field_77994_a) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            if (doAdd) {
                inventory.func_70299_a(i, stack.func_77946_l());
                inventory.func_70301_a((int)i).field_77994_a = stack.field_77994_a - added;
            }
            return stack.field_77994_a;
        }
        return added;
    }
}

