/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Timer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final TileEntity[] cache = new TileEntity[6];
    private final int[] delay = new int[6];
    private final TileEntity source;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    private TileEntity searchSide(ForgeDirection side) {
        int sz;
        int sy;
        int sx;
        World world = this.source.func_145831_w();
        if (world.func_72899_e(sx = this.source.field_145851_c + side.offsetX, sy = this.source.field_145848_d + side.offsetY, sz = this.source.field_145849_e + side.offsetZ) && world.func_147439_a(sx, sy, sz) != Blocks.field_150350_a) {
            return world.func_147438_o(sx, sy, sz);
        }
        return null;
    }

    public void refresh() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(int side, TileEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    private void changed() {
        for (ICacheListener listener : this.listeners) {
            listener.changed();
        }
    }

    private boolean areCoordinatesOnSide(ForgeDirection side, TileEntity target) {
        return this.source.field_145851_c + side.offsetX == target.field_145851_c && this.source.field_145848_d + side.offsetY == target.field_145848_d && this.source.field_145849_e + side.offsetZ == target.field_145849_e;
    }

    public TileEntity getTileOnSide(ForgeDirection side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].func_145837_r() || !this.areCoordinatesOnSide(side, this.cache[s])) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.func_145831_w(), this.delay[s])) {
            this.setTile(s, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public TileEntity getSource() {
        return this.source;
    }

    public static interface ICacheListener {
        public void changed();

        public void purge();
    }
}

