/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.collect.ForwardingCollection;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;

public class RevolvingList<T>
extends ForwardingCollection<T> {
    private final Deque<T> list = new LinkedList<T>();

    public RevolvingList() {
    }

    public RevolvingList(Collection<? extends T> collection) {
        this.list.addAll(collection);
    }

    protected Collection<T> delegate() {
        return this.list;
    }

    public void rotateLeft() {
        if (this.list.isEmpty()) {
            return;
        }
        this.list.addFirst(this.list.removeLast());
    }

    public void rotateRight() {
        if (this.list.isEmpty()) {
            return;
        }
        this.list.addLast(this.list.removeFirst());
    }

    public T getCurrent() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.getFirst();
    }

    public void setCurrent(T e) {
        if (!this.contains(e)) {
            return;
        }
        if (e == null) {
            while (this.getCurrent() != null) {
                this.rotateRight();
            }
        } else {
            while (this.getCurrent() == null || !this.getCurrent().equals(e)) {
                this.rotateRight();
            }
        }
    }
}

