/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ISocketable;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.DelayTimer;
import forestry.plugins.PluginIC2;
import ic2.api.energy.prefab.BasicSink;
import ic2.api.item.ElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EngineTin
extends Engine
implements ISocketable,
IInventory {
    public static final short SLOT_BATTERY = 0;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final EuConfig euConfig = new EuConfig(5, 20, 10);
    protected BasicSink ic2EnergySink;
    private final DelayTimer delayUpdateTimer = new DelayTimer();

    public EngineTin() {
        super(3000, 100000, 4000);
        this.setHints(Config.hints.get("engine.tin"));
        this.setInternalInventory(new EngineTinInventoryAdapter(this));
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySink = new BasicSink((TileEntity)this, this.euConfig.euStorage, 3);
        }
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineTinGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.func_145839_a(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145839_a(nbttagcompound);
        }
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145841_b(nbttagcompound);
        }
        this.sockets.writeToNBT(nbttagcompound);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.func_145843_s();
        }
        super.func_145843_s();
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.isRedstoneActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.isRedstoneActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.energyManager.getTotalEnergyStored() / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        if (this.setErrorCondition(this.ic2EnergySink == null, EnumErrorCode.NOENERGYNET)) {
            return;
        }
        this.ic2EnergySink.func_145845_h();
        super.updateServerSide();
        if (this.forceCooldown) {
            return;
        }
        if (this.getInternalInventory().func_70301_a(0) != null) {
            this.replenishFromBattery(0);
        }
        if (!this.delayUpdateTimer.delayPassed(this.field_145850_b, 80L)) {
            return;
        }
        boolean canUseEnergy = this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
        this.setErrorCondition(!canUseEnergy, EnumErrorCode.NOFUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (!this.isRedstoneActivated()) {
            return;
        }
        if (this.ic2EnergySink.useEnergy((double)this.euConfig.euForCycle)) {
            this.currentOutput = this.euConfig.rfPerCycle;
            this.energyManager.generateEnergy(this.euConfig.rfPerCycle);
        }
    }

    private void replenishFromBattery(int slot) {
        if (!this.isRedstoneActivated()) {
            return;
        }
        this.ic2EnergySink.discharge(this.getInternalInventory().func_70301_a(slot), this.euConfig.euForCycle * 3);
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.ic2EnergySink != null && this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
    }

    public int getStorageScaled(int i) {
        if (this.ic2EnergySink == null) {
            return 0;
        }
        return Math.min(i, (int)(this.ic2EnergySink.getEnergyStored() * (double)i) / this.ic2EnergySink.getCapacity());
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.energyManager.fromGuiInt(j);
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                if (this.ic2EnergySink == null) break;
                this.ic2EnergySink.setEnergyStored((double)j);
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 1, this.energyManager.toGuiInt());
        iCrafting.func_71112_a(containerEngine, 2, this.heat);
        if (this.ic2EnergySink != null) {
            iCrafting.func_71112_a(containerEngine, 3, (int)((short)this.ic2EnergySink.getEnergyStored()));
        }
    }

    public void changeEnergyConfig(int euChange, int rfChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.rfPerCycle += rfChange;
        this.euConfig.euStorage += storageChange;
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.setCapacity(this.euConfig.euStorage);
        }
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.func_70299_a(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    private static class EngineTinInventoryAdapter
    extends TileInventoryAdapter<EngineTin> {
        public EngineTinInventoryAdapter(EngineTin engineTin) {
            super(engineTin, 1, "electrical");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return ElectricItem.manager.getCharge(itemStack) > 0.0;
            }
            return false;
        }
    }

    protected static class EuConfig {
        public int euForCycle;
        public int rfPerCycle;
        public int euStorage;

        public EuConfig(int euForCycle, int rfPerCycle, int euStorage) {
            this.euForCycle = euForCycle;
            this.rfPerCycle = rfPerCycle;
            this.euStorage = euStorage;
        }
    }
}

